/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.Primitives;

public abstract class TestClassTransformer
implements MockTransformer {
    private final Class<?> testClass;
    private final Class<? extends Annotation> testMethodAnnotationType;

    public static ForTestClass forTestClass(final Class<?> testClass) {
        return new ForTestClass(){

            @Override
            public ForTestClass.RemovesTestMethodAnnotation removesTestMethodAnnotation(final Class<? extends Annotation> testMethodAnnotation) {
                return new ForTestClass.RemovesTestMethodAnnotation(){

                    @Override
                    public TestClassTransformer fromMethods(final Collection<Method> testMethodsThatRunOnOtherClassLoaders) {
                        return new TestClassTransformer(testClass, testMethodAnnotation){
                            Collection<String> methodsThatRunOnOtherClassLoaders;

                            @Override
                            boolean mustHaveTestAnnotationRemoved(CtMethod method) throws NotFoundException {
                                if (null == this.methodsThatRunOnOtherClassLoaders) {
                                    this.methodsThatRunOnOtherClassLoaders = new HashSet<String>();
                                    for (Method m : testMethodsThatRunOnOtherClassLoaders) {
                                        this.methodsThatRunOnOtherClassLoaders.add(TestClassTransformer.signatureOf(m));
                                    }
                                    testMethodsThatRunOnOtherClassLoaders.clear();
                                }
                                return this.methodsThatRunOnOtherClassLoaders.contains(TestClassTransformer.signatureOf(method));
                            }
                        };
                    }

                    @Override
                    public TestClassTransformer fromAllMethodsExcept(Method singleMethodToRunOnTargetClassLoader) {
                        final String targetMethodSignature = TestClassTransformer.signatureOf(singleMethodToRunOnTargetClassLoader);
                        return new TestClassTransformer(testClass, testMethodAnnotation){

                            @Override
                            boolean mustHaveTestAnnotationRemoved(CtMethod method) throws Exception {
                                return !TestClassTransformer.signatureOf(method).equals(targetMethodSignature);
                            }
                        };
                    }
                };
            }
        };
    }

    private TestClassTransformer(Class<?> testClass, Class<? extends Annotation> testMethodAnnotationType) {
        this.testClass = testClass;
        this.testMethodAnnotationType = testMethodAnnotationType;
    }

    private boolean isTestClass(CtClass clazz) {
        try {
            return Class.forName(clazz.getName(), false, this.testClass.getClassLoader()).isAssignableFrom(this.testClass);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private boolean isNestedWithinTestClass(CtClass clazz) {
        String clazzName = clazz.getName();
        return clazzName.startsWith(this.testClass.getName()) && '$' == clazzName.charAt(this.testClass.getName().length());
    }

    private Class<?> asOriginalClass(CtClass type2) throws Exception {
        try {
            return type2.isArray() ? Array.newInstance(this.asOriginalClass(type2.getComponentType()), 0).getClass() : (type2.isPrimitive() ? Primitives.getClassFor((CtPrimitiveType)type2) : Class.forName(type2.getName(), true, this.testClass.getClassLoader()));
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot resolve type: " + type2, ex);
        }
    }

    private Class<?>[] asOriginalClassParams(CtClass[] parameterTypes) throws Exception {
        Class[] classParams = new Class[parameterTypes.length];
        for (int i = 0; i < classParams.length; ++i) {
            classParams[i] = this.asOriginalClass(parameterTypes[i]);
        }
        return classParams;
    }

    abstract boolean mustHaveTestAnnotationRemoved(CtMethod var1) throws Exception;

    private void removeTestMethodAnnotationFrom(CtMethod m) throws ClassNotFoundException {
        AnnotationsAttribute attr = (AnnotationsAttribute)m.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        javassist.bytecode.annotation.Annotation[] newAnnotations = new javassist.bytecode.annotation.Annotation[attr.numAnnotations() - 1];
        int i = -1;
        for (javassist.bytecode.annotation.Annotation a : attr.getAnnotations()) {
            if (a.getTypeName().equals(this.testMethodAnnotationType.getName())) continue;
            newAnnotations[++i] = a;
        }
        attr.setAnnotations(newAnnotations);
    }

    private void removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(CtClass clazz) throws Exception {
        for (CtMethod m : clazz.getDeclaredMethods()) {
            if (!m.hasAnnotation(this.testMethodAnnotationType) || !this.mustHaveTestAnnotationRemoved(m)) continue;
            this.removeTestMethodAnnotationFrom(m);
        }
    }

    @Override
    public CtClass transform(CtClass clazz) throws Exception {
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        if (this.isTestClass(clazz)) {
            this.removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(clazz);
            this.addLifeCycleNotifications(clazz);
            this.makeDeferConstructorNonPublic(clazz);
            this.restoreOriginalConstructorsAccesses(clazz);
        } else if (this.isNestedWithinTestClass(clazz)) {
            this.makeDeferConstructorNonPublic(clazz);
            this.restoreOriginalConstructorsAccesses(clazz);
        }
        return clazz;
    }

    private void addLifeCycleNotifications(CtClass clazz) {
        try {
            this.addClassInitializerNotification(clazz);
            this.addConstructorNotification(clazz);
        }
        catch (CannotCompileException ex) {
            throw new Error("Powermock error: " + ex.getMessage(), ex);
        }
    }

    private void addClassInitializerNotification(CtClass clazz) throws CannotCompileException {
        if (null == clazz.getClassInitializer()) {
            clazz.makeClassInitializer();
        }
        clazz.getClassInitializer().insertBefore(GlobalNotificationBuildSupport.class.getName() + ".testClassInitiated(" + clazz.getName() + ".class);");
    }

    private static boolean hasSuperClass(CtClass clazz) {
        try {
            CtClass superClazz = clazz.getSuperclass();
            return null != superClazz && !"java.lang.Object".equals(superClazz.getName());
        }
        catch (NotFoundException noWasSuperClassFound) {
            return false;
        }
    }

    private void addConstructorNotification(CtClass clazz) throws CannotCompileException {
        String notificationCode = GlobalNotificationBuildSupport.class.getName() + ".testInstanceCreated(this);";
        boolean asFinally = !TestClassTransformer.hasSuperClass(clazz);
        for (CtConstructor constr : clazz.getDeclaredConstructors()) {
            constr.insertAfter(notificationCode, asFinally);
        }
    }

    private void restoreOriginalConstructorsAccesses(CtClass clazz) throws Exception {
        Class<?> originalClass = this.testClass.getName().equals(clazz.getName()) ? this.testClass : Class.forName(clazz.getName(), true, this.testClass.getClassLoader());
        for (CtConstructor ctConstr : clazz.getConstructors()) {
            int ctModifiers = ctConstr.getModifiers();
            if (!Modifier.isPublic(ctModifiers)) continue;
            int desiredAccessModifiers = originalClass.getDeclaredConstructor(this.asOriginalClassParams(ctConstr.getParameterTypes())).getModifiers();
            if (Modifier.isPrivate(desiredAccessModifiers)) {
                ctConstr.setModifiers(Modifier.setPrivate(ctModifiers));
                continue;
            }
            if (Modifier.isProtected(desiredAccessModifiers)) {
                ctConstr.setModifiers(Modifier.setProtected(ctModifiers));
                continue;
            }
            if (Modifier.isPublic(desiredAccessModifiers)) continue;
            ctConstr.setModifiers(Modifier.setPackage(ctModifiers));
        }
    }

    private void makeDeferConstructorNonPublic(CtClass clazz) {
        block2: for (CtConstructor constr : clazz.getConstructors()) {
            try {
                for (CtClass paramType : constr.getParameterTypes()) {
                    if (!IndicateReloadClass.class.getName().equals(paramType.getName())) continue;
                    int modifiers = constr.getModifiers();
                    if (!Modifier.isPublic(modifiers)) continue block2;
                    constr.setModifiers(Modifier.setProtected(modifiers));
                    continue block2;
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private static String signatureOf(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            paramTypeNames[i] = paramTypes[i].getSimpleName();
        }
        return TestClassTransformer.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
    }

    private static String signatureOf(CtMethod m) throws NotFoundException {
        CtClass[] paramTypes = m.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            paramTypeNames[i] = paramTypes[i].getSimpleName();
        }
        return TestClassTransformer.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
    }

    private static String createSignature(String testClass, String returnType, String methodName, String[] paramTypes) {
        StringBuilder builder = new StringBuilder(testClass).append('\n').append(returnType).append('\n').append(methodName);
        for (String param2 : paramTypes) {
            builder.append('\n').append(param2);
        }
        return builder.toString();
    }

    public static interface ForTestClass {
        public RemovesTestMethodAnnotation removesTestMethodAnnotation(Class<? extends Annotation> var1);

        public static interface RemovesTestMethodAnnotation {
            public TestClassTransformer fromMethods(Collection<Method> var1);

            public TestClassTransformer fromAllMethodsExcept(Method var1);
        }
    }
}

