/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.api.IngestionApiRestImpl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.logging.AgathaLogger;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.ArtefactIsKnownVM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.CrawlerJobMetadata;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.CrawlerProbeResultVM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.DedupeData;
import com.xebialabs.impact.api.KnownArtefactRequestDescriptionVM;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.MDC;

public abstract class AbstractCrawler<C, M extends BaseCrawlerMessage, R extends Closeable>
implements Runnable {
    private final String pluginId;
    protected final AtomicBoolean isRunning = new AtomicBoolean(true);
    protected final AtomicBoolean shouldBlockAllThreads = new AtomicBoolean(false);
    private final String tenantId;
    private AgathaLogger logger = AgathaLogger.getLogger(this, AbstractCrawler.class);
    private int currentCredentialsIndex;
    protected final ObjectMapper mapper;
    private final int yearsBack;
    int sleepMs;
    int retryDelayMin;
    protected C client;
    R remoteSource;
    protected CrawlerCredentialsDTO crawlerCredentialsPackage;
    protected URL endpoint;
    protected String username;
    private String networkId;
    String passwordOrToken;
    double throttleFactor = 1.0;
    protected Date retryQueueDelayedUntil;
    private final IngestionApi ingestionApi;

    public AbstractCrawler(String pluginId, Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        this.pluginId = pluginId;
        this.networkId = AgathaConfiguration.getNetworkId();
        this.tenantId = AgathaConfiguration.getTenantId();
        this.yearsBack = AgathaConfiguration.getCrawlMaxYearsBack();
        this.sleepMs = AgathaConfiguration.getCrawlerSleepMs();
        this.retryDelayMin = AgathaConfiguration.getCrawlerRetryDelayMin();
        this.mapper = this.createMapper();
        this.ingestionApi = ingestionApiProvider.apply(this.mapper);
    }

    public AbstractCrawler(String pluginId) {
        this(pluginId, IngestionApiRestImpl::new);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper created = new ObjectMapper();
        created.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return created;
    }

    void setCredentials(String username, String passwordOrToken) {
        this.username = username;
        this.passwordOrToken = passwordOrToken;
    }

    public void setThrottleFactor(double throttleFactor) {
        this.throttleFactor = throttleFactor;
    }

    protected void switchCredentials(List<CrawlerCredentialsDTO.CredentialsWrapper> credentialsList) {
        this.currentCredentialsIndex = this.currentCredentialsIndex >= credentialsList.size() ? 0 : this.currentCredentialsIndex;
        CrawlerCredentialsDTO.CredentialsWrapper credentials = credentialsList.get(this.currentCredentialsIndex);
        this.setCredentials(credentials.getUsername(), credentials.getPassword());
        ++this.currentCredentialsIndex;
    }

    protected CrawlerJobResult handleCrawlerException(CrawlerJobWrapper crawlerJob, CrawlerWorkException e) {
        return CrawlerJobResult.fail(e.getMessage());
    }

    @Override
    public void run() {
        MDC.put("crawlerName", Thread.currentThread().getName());
        while (this.isRunning.get()) {
            this.executeSingleLoop();
        }
        this.shutdown();
    }

    protected void executeSingleLoop() {
        Optional<Object> crawlerJob = Optional.empty();
        try {
            Optional<CrawlerMessageWithCredentials> pollResponse = this.pollWorkQueue();
            if (!pollResponse.isPresent()) {
                return;
            }
            crawlerJob = this.handlePollResponse(pollResponse.get());
            if (crawlerJob.isPresent()) {
                this.handleValidMessage((CrawlerJobWrapper)crawlerJob.get());
            }
        }
        catch (CrawlerWorkException e) {
            if (crawlerJob.isPresent()) {
                this.logger.error("Error while processing job [{}]: {}", crawlerJob.get(), e);
            } else {
                this.logger.error("Severe error: {}", e);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error("Uncatched exception: [{}]", e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleValidMessage(CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        this.crawlerCredentialsPackage = crawlerJob.getCredentialsPackage();
        if (this.crawlerCredentialsPackage.getCredentials().isEmpty()) {
            throw new CrawlerWorkException("Crawler credentials wrapper doesn't include any credentials!");
        }
        try {
            this.endpoint = new URL(this.crawlerCredentialsPackage.getEndpoint());
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException(e);
        }
        this.switchCredentials(this.crawlerCredentialsPackage.getCredentials());
        this.initOrUpdateClient();
        this.execute(crawlerJob);
    }

    protected void execute(CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        MDC.put("crawlerName", Thread.currentThread().getName() + "-" + this.tenantId + "-" + this.pluginId + "-" + this.networkId + "-" + crawlerJob.getMessage().getDataSourceDetails().getDataSourceId());
        CrawlerJobResult jobResult = crawlerJob.getMessage().getProbeId() != null ? this.handleProbeMessage(crawlerJob) : this.crawlItem(crawlerJob);
        if (jobResult == null) {
            return;
        }
        if (jobResult.isSuccess()) {
            this.successJobResult(crawlerJob);
        } else {
            this.failureJobResult(crawlerJob, jobResult);
        }
    }

    private void failureJobResult(CrawlerJobWrapper crawlerJob, CrawlerJobResult jobResult) throws CrawlerWorkException {
        this.retryOrBuryMessage(crawlerJob, jobResult.getErrorMessage());
    }

    private void successJobResult(CrawlerJobWrapper crawlerJob) {
        this.ackMessage(crawlerJob);
    }

    private CrawlerJobResult handleProbeMessage(CrawlerJobWrapper crawlerJob) {
        PushProbeUMStatusRequestVM pushProbeUMStatusRequestVM = new PushProbeUMStatusRequestVM();
        pushProbeUMStatusRequestVM.setProbeId(crawlerJob.getMessage().getProbeId()).setDataSourceId(crawlerJob.getMessage().getDataSourceDetails().getDataSourceId()).setProbeStatus(new CrawlerProbeResultVM().setResults(new ArrayList<ProbeResultMetadataVM>())).setPluginId(this.pluginId).setTenantId(this.tenantId);
        for (int i = 0; i < crawlerJob.getCredentialsPackage().getCredentials().size(); ++i) {
            ProbeResultMetadataVM probe = this.probe(crawlerJob);
            pushProbeUMStatusRequestVM.getProbeStatus().getResults().add(probe);
            this.switchCredentials(crawlerJob.getCredentialsPackage().getCredentials());
            this.initOrUpdateClient();
        }
        try {
            this.ingestionApi.pushProbeUmStatus(pushProbeUMStatusRequestVM);
            return CrawlerJobResult.success();
        }
        catch (Exception e) {
            return CrawlerJobResult.fail(e.getMessage());
        }
    }

    private void retryOrBuryMessage(CrawlerJobWrapper crawlerJob, String errorMessage) throws CrawlerWorkException {
        if (crawlerJob.getMessage().getMetadata().getFailures() > AgathaConfiguration.getCrawlerMaxRetry()) {
            this.logger.error("Error while processing job, too much failures, sending to DLQ [{}]: {}", crawlerJob.getMessage(), errorMessage);
            this.buryMessage(crawlerJob);
        } else {
            this.logger.error("Error while processing job, failure count did not exceed threshold, sending to retry queue [{}]: {}", crawlerJob.getMessage(), errorMessage);
            Date delayUntil = new DateTime(new Date()).plusMinutes(this.retryDelayMin).toDate();
            this.scheduleRetryForMessage(crawlerJob, errorMessage, delayUntil);
            this.retryQueueDelayedUntil = delayUntil;
        }
    }

    protected Optional<CrawlerMessageWithCredentials> pollWorkQueue() {
        try {
            PullMessagesWithStreamingResponseVM responseVM = this.ingestionApi.pullUMMessage(this.pluginId, this.networkId);
            if (responseVM.getMessages().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(responseVM.getMessages().get(0));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    protected Optional<CrawlerJobWrapper> handlePollResponse(CrawlerMessageWithCredentials pollWrapper) throws CrawlerWorkException {
        BaseCrawlerMessage message = pollWrapper.getMessage();
        Optional<CrawlerCredentialsDTO> crawlerCredentials = Optional.ofNullable(pollWrapper.getCredentials());
        if (!crawlerCredentials.map(CrawlerCredentialsDTO::getCredentials).filter(l -> !l.isEmpty()).isPresent()) {
            this.logger.error("Credentials list from Ingestion API is empty!");
            this.retryOrBuryMessage(new CrawlerJobWrapper(pollWrapper.getMessageId(), pollWrapper.getTenantId(), message, null), "Credentials list from Ingestion API is empty!");
            return Optional.empty();
        }
        crawlerCredentials.map(CrawlerCredentialsDTO::getCrawlerConfig).ifPresent(config -> {
            this.logger.setLogReportingEnabled(config.isLogReportingEnabled());
            this.logger.setCurrentLogReportLevel(config.getCurLogReportLevel());
        });
        this.logger.setDataSourceDetails(this.pluginId, this.networkId, pollWrapper.getDataSourceId());
        this.logger.info("Got a [{}] message", message.getClass().getSimpleName());
        return Optional.of(new CrawlerJobWrapper(pollWrapper.getMessageId(), pollWrapper.getTenantId(), message, crawlerCredentials.orElse(null)));
    }

    public <D> boolean sendCrawledDataAndDecideToContinue(M message, D data, DataSourceTypeEnum type2, String artefactId, String version) throws CrawlerWorkException {
        Map<String, Object> pushDataPayload = this.prepareCrawlerData(message, data, type2, artefactId, version);
        try {
            return !this.ingestionApi.pushUMData(pushDataPayload).isKnown();
        }
        catch (IOException e) {
            throw new CrawlerWorkException(e);
        }
    }

    private <D> Map<String, Object> prepareCrawlerData(M message, D data, DataSourceTypeEnum type2, String artefactId, String version) {
        DedupeData dedupeData = new DedupeData().setVersion(version);
        if (((BaseCrawlerMessage)message).getMetadata().isIncremental()) {
            dedupeData.setIncrementalRunTimestamp(((BaseCrawlerMessage)message).getMetadata().getRunTimestamp());
        } else {
            dedupeData.setNonIncrementalRunTimestamp(((BaseCrawlerMessage)message).getMetadata().getRunTimestamp());
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (data != null) {
            payload.put("data", data);
        }
        payload.put("dedupeData", dedupeData);
        return Collections.singletonMap(AgathaConfiguration.getTenantId(), Collections.singletonMap(type2.toString(), Collections.singletonMap(this.pluginId, Collections.singletonMap(((BaseCrawlerMessage)message).getDataSourceDetails().getDataSourceId(), Collections.singletonMap(artefactId, payload)))));
    }

    public <D> boolean sendCrawledDataStreamAndDecideToContinue(M message, D data, Reader dataStream, DataSourceTypeEnum type2, String artefactId, String version) throws CrawlerWorkException {
        Map<String, Object> pushDataPayload = this.prepareCrawlerData(message, data, type2, artefactId, version);
        try {
            return !this.ingestionApi.pushUMDataAsSource(pushDataPayload, dataStream).isKnown();
        }
        catch (IOException e) {
            throw new CrawlerWorkException(e);
        }
    }

    public boolean decideToContinueBeforeCrawling(M message, String version, String artefactId, DataSourceTypeEnum type2) {
        Map<String, Object> pushDataPayload = this.prepareCrawlerData(message, null, type2, artefactId, version);
        try {
            return !this.ingestionApi.pushUMData(pushDataPayload).isKnown();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, Boolean> getKnownArtefacts(List<KnownArtefactRequestDescriptionVM> artefacts, String dataSourceId, DataSourceTypeEnum type2) {
        CheckWhichUMArtefactsAreKnownRequestVM vm = new CheckWhichUMArtefactsAreKnownRequestVM();
        vm.setArtefacts(artefacts);
        vm.setDataSourceId(dataSourceId);
        vm.setDataSourceType(DataSourceTypeEnum.valueOf(type2.name()));
        vm.setPluginId(this.pluginId);
        vm.setTenantId(this.tenantId);
        try {
            return this.ingestionApi.checkWhichUMArtefactsAreKnown(vm).getArtefacts().stream().collect(Collectors.toMap(ArtefactIsKnownVM::getArtefactId, ArtefactIsKnownVM::getIsKnown));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void sendCrawlerTaskMessage(BaseCrawlerMessage message) throws CrawlerWorkException {
        PushCrawlerUMMessagesRequestVM push = new PushCrawlerUMMessagesRequestVM().setDataSourceId(message.getDataSourceDetails().getDataSourceId()).setPluginId(message.getPluginId()).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(message.getDataSourceDetails().getNetworkId()).setMessages(Collections.singletonList(message));
        try {
            this.ingestionApi.pushUMMessage(push);
        }
        catch (IOException e) {
            throw new CrawlerWorkException(e);
        }
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        BaseCrawlerMessage msg = (BaseCrawlerMessage)cls.newInstance();
        msg.setTenantId(oldMsg.getTenantId());
        msg.setPluginId(oldMsg.getPluginId());
        msg.setMetadata(oldMsg.getMetadata());
        msg.setDataSourceDetails(oldMsg.getDataSourceDetails());
        return (V)msg;
    }

    protected void ackMessage(CrawlerJobWrapper crawlerJob) {
        this.ackMessage(crawlerJob.getMessageId(), crawlerJob.getTenantId(), crawlerJob.getMessage().getPluginId(), crawlerJob.getMessage().getDataSourceDetails().getDataSourceId(), crawlerJob.getMessage().getDataSourceDetails().getNetworkId());
    }

    protected void ackMessage(String messageId, String tenantId, String pluginId, String dataSourceId, String networkId) {
        this.logger.debug("ACKing message with ID [{}] of tenant [{}]", messageId, tenantId);
        AckUmMessagesVM ackUmMessagesVM = new AckUmMessagesVM().setNetworkId(networkId).setPluginId(pluginId).setTenantId(AgathaConfiguration.getTenantId()).setDataSourceId(dataSourceId).setMessageIds(Collections.singletonList(messageId));
        try {
            this.ingestionApi.ackUmMessages(ackUmMessagesVM);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void scheduleRetryForMessage(CrawlerJobWrapper crawlerJob, String errorMessage, Date delayUntil) throws CrawlerWorkException {
        CrawlerJobMetadata updatedMetadata = crawlerJob.getMessage().getMetadata().setFailures(crawlerJob.getMessage().getMetadata().getFailures() + 1).setErrorMessage(errorMessage).setDelayUntil(delayUntil.getTime());
        Object updatedMessage = crawlerJob.getMessage().setMetadata(updatedMetadata);
        PushCrawlerUMMessagesRequestVM push = new PushCrawlerUMMessagesRequestVM().setDataSourceId(crawlerJob.getMessage().getDataSourceDetails().getDataSourceId()).setPluginId(crawlerJob.getMessage().getPluginId()).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(crawlerJob.getMessage().getDataSourceDetails().getNetworkId()).setMessages(Collections.singletonList(updatedMessage));
        try {
            this.ingestionApi.pushUMMessage(push);
            this.ackMessage(crawlerJob);
        }
        catch (IOException e) {
            throw new CrawlerWorkException(e);
        }
    }

    private void buryMessage(CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        PushCrawlerUMMessagesRequestVM push = new PushCrawlerUMMessagesRequestVM().setDlq(true).setDataSourceId(crawlerJob.getMessage().getDataSourceDetails().getDataSourceId()).setPluginId(crawlerJob.getMessage().getPluginId()).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(crawlerJob.getMessage().getDataSourceDetails().getNetworkId()).setMessages(Collections.singletonList(crawlerJob.getMessage()));
        try {
            this.ingestionApi.pushUMMessage(push);
            this.ackMessage(crawlerJob);
        }
        catch (IOException e) {
            throw new CrawlerWorkException(e);
        }
    }

    protected void shutdown() {
        this.ingestionApi.shutdown();
    }

    void stop() {
        this.logger.info("shutting down crawler");
        this.isRunning.set(false);
    }

    public Date getOldestValidDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -1 * this.yearsBack);
        return cal.getTime();
    }

    public int getYearsBack() {
        return this.yearsBack;
    }

    public String generateDataId(String ... args) {
        Joiner joiner = Joiner.on("/").useForNull("null");
        LinkedList<String> paths = new LinkedList<String>(Arrays.asList(args));
        paths.add(0, this.username);
        return joiner.join(paths);
    }

    public C getClient() {
        return this.client;
    }

    public List<String> getFilterValues(String filterKey) {
        CrawlerCredentialsDTO.CredentialFilters filters = this.crawlerCredentialsPackage.getFilters();
        return Optional.ofNullable(filters.getFilters()).map(v -> (Map)v.get(filterKey)).map(v -> (List)v.get("filter")).orElse(new ArrayList());
    }

    public String getUsername() {
        return this.username;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public abstract void initOrUpdateClient();

    protected abstract CrawlerJobResult crawlItem(CrawlerJobWrapper var1);

    protected abstract ProbeResultMetadataVM probe(CrawlerJobWrapper var1);

    public String getTenantId() {
        return this.tenantId;
    }

    public IngestionApi getIngestionApi() {
        return this.ingestionApi;
    }
}

