/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class PropertiesFinder {
    private final ClassLoader classLoader;

    PropertiesFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    List<ConfigurationSource> find(String configurationFile) throws IOException, URISyntaxException {
        ArrayList<ConfigurationSource> configurations = new ArrayList<ConfigurationSource>();
        Enumeration<URL> resources = this.classLoader.getResources(configurationFile);
        while (resources.hasMoreElements()) {
            URL candidate = resources.nextElement();
            configurations.add(new ConfigurationSource(candidate.getFile(), candidate.openStream()));
        }
        return configurations;
    }

    static class ConfigurationSource {
        private final String location;
        private final InputStream inputStream;

        ConfigurationSource(String location, InputStream inputStream) {
            this.location = location;
            this.inputStream = inputStream;
        }

        InputStream inputStream() {
            return this.inputStream;
        }

        String getLocation() {
            return this.location;
        }

        public String toString() {
            return "ConfigurationSource{location='" + this.location + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationSource that = (ConfigurationSource)o;
            return this.getLocation() != null ? this.getLocation().equals(that.getLocation()) : that.getLocation() == null;
        }

        public int hashCode() {
            return this.getLocation() != null ? this.getLocation().hashCode() : 0;
        }
    }
}

