/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.proxy;

import java.util.ArrayList;
import org.powermock.reflect.internal.proxy.UnproxiedType;

class UnproxiedTypeFactory {
    private static final String[] RESTRICTED_INTERFACES = new String[]{"cglib.proxy.Factory"};

    UnproxiedTypeFactory() {
    }

    UnproxiedType createFromInterfaces(Class<?>[] interfaces) {
        Class[] filteredInterfaces = this.filterInterfaces(interfaces);
        if (filteredInterfaces.length == 0) {
            return new UnproxiedTypeImpl((Class)Object.class);
        }
        if (filteredInterfaces.length == 1) {
            return new UnproxiedTypeImpl((Class)filteredInterfaces[0]);
        }
        return new UnproxiedTypeImpl(filteredInterfaces);
    }

    UnproxiedType createFromSuperclassAndInterfaces(Class<?> superclass, Class<?>[] interfaces) {
        if (Object.class.equals(superclass)) {
            return this.createFromInterfaces(interfaces);
        }
        Class[] filteredInterfaces = this.filterInterfaces(interfaces);
        return new UnproxiedTypeImpl(superclass, filteredInterfaces);
    }

    UnproxiedType createFromType(Class<?> type2) {
        return new UnproxiedTypeImpl((Class)type2);
    }

    private Class<?>[] filterInterfaces(Class<?>[] interfaces) {
        ArrayList filtered2 = new ArrayList();
        for (Class<?> anInterface : interfaces) {
            if (this.isMockFrameworkInterface(anInterface)) continue;
            filtered2.add(anInterface);
        }
        return filtered2.toArray(new Class[filtered2.size()]);
    }

    private boolean isMockFrameworkInterface(Class<?> anInterface) {
        String name = anInterface.getName();
        for (String restrictedInterface : RESTRICTED_INTERFACES) {
            if (!name.contains(restrictedInterface)) continue;
            return true;
        }
        return false;
    }

    private static class UnproxiedTypeImpl
    implements UnproxiedType {
        private final Class<?> type;
        private final Class<?>[] interfaces;

        private UnproxiedTypeImpl(Class<?> type2) {
            this.type = type2;
            this.interfaces = new Class[0];
        }

        private UnproxiedTypeImpl(Class<?>[] interfaces) {
            this.type = null;
            this.interfaces = interfaces;
        }

        private UnproxiedTypeImpl(Class<?> type2, Class<?>[] interfaces) {
            this.type = type2;
            this.interfaces = interfaces;
        }

        @Override
        public Class<?> getOriginalType() {
            return this.type;
        }

        @Override
        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }
    }
}

