/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.InputStream;
import java.net.URL;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.plugins.PluginFileReader;
import org.mockito.internal.util.io.IOUtil;
import org.mockito.plugins.PluginSwitch;

class PluginFinder {
    private final PluginSwitch pluginSwitch;

    public PluginFinder(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
    }

    String findPluginClass(Iterable<URL> resources) {
        for (URL resource : resources) {
            InputStream s2 = null;
            try {
                s2 = resource.openStream();
                String pluginClassName = new PluginFileReader().readPluginClass(s2);
                if (pluginClassName == null || !this.pluginSwitch.isEnabled(pluginClassName)) continue;
                String string = pluginClassName;
                return string;
            }
            catch (Exception e) {
                throw new MockitoException("Problems reading plugin implementation from: " + resource, e);
            }
            finally {
                IOUtil.closeQuietly(s2);
            }
        }
        return null;
    }
}

