/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.List;
import org.assertj.core.api.AbstractOptionalAssert;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.ProxifyExtractingResult;
import org.assertj.core.internal.cglib.proxy.Callback;
import org.assertj.core.internal.cglib.proxy.CallbackFilter;
import org.assertj.core.internal.cglib.proxy.Enhancer;
import org.assertj.core.util.Arrays;

class SoftProxies {
    private final ErrorCollector collector = new ErrorCollector();

    SoftProxies() {
    }

    void collectError(Throwable error) {
        this.collector.addError(error);
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V create(Class<V> assertClass, Class<T> actualClass, T actual) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(assertClass);
        enhancer.setCallbackFilter(CollectErrorsOrCreateExtractedProxy.FILTER);
        enhancer.setCallbacks(new Callback[]{this.collector, new ProxifyExtractingResult(this)});
        return (V)enhancer.create(Arrays.array(actualClass), Arrays.array(actual));
    }

    public boolean wasSuccess() {
        return this.collector.wasSuccess();
    }

    private static enum CollectErrorsOrCreateExtractedProxy implements CallbackFilter
    {
        FILTER;

        private static final int ERROR_COLLECTOR_INDEX = 0;
        private static final int PROXIFY_RESULT_INDEX = 1;

        @Override
        public int accept(Method method) {
            return this.keepProxifying(method) ? 1 : 0;
        }

        private boolean keepProxifying(Method method) {
            return this.isExtractingMethod(method) || this.isFilteredOnMethod(method) || this.isOptionalAssertFlatMap(method) || this.isOptionalAssertMap(method);
        }

        private boolean isExtractingMethod(Method method) {
            return method.getName().toLowerCase().contains("extracting");
        }

        private boolean isFilteredOnMethod(Method method) {
            return method.getName().contains("filteredOn");
        }

        private boolean isOptionalAssertMap(Method method) {
            return method.getDeclaringClass().equals(AbstractOptionalAssert.class) && method.getName().contains("map");
        }

        private boolean isOptionalAssertFlatMap(Method method) {
            return method.getDeclaringClass().equals(AbstractOptionalAssert.class) && method.getName().contains("flatMap");
        }
    }
}

