/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.util.IgnoreUtils;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringController
extends DecoratedTypeElement
implements HasFacets {
    private final EnunciateSpringWebContext context;
    private final Set<String> paths;
    private final Set<String> consumesMime;
    private final Set<String> producesMime;
    private final org.springframework.web.bind.annotation.RequestMapping mappingInfo;
    private final List<RequestMapping> requestMappings;
    private final Set<Facet> facets = new TreeSet<Facet>();

    public SpringController(TypeElement delegate, EnunciateSpringWebContext context) {
        this(delegate, delegate.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class), context);
    }

    private SpringController(TypeElement delegate, org.springframework.web.bind.annotation.RequestMapping mappingInfo, EnunciateSpringWebContext context) {
        this(delegate, SpringController.loadPaths(mappingInfo), mappingInfo, context);
    }

    private static Set<String> loadPaths(org.springframework.web.bind.annotation.RequestMapping mappingInfo) {
        TreeSet<String> paths = new TreeSet<String>();
        if (mappingInfo != null) {
            try {
                paths.addAll(Arrays.asList(mappingInfo.path()));
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {
                // empty catch block
            }
            paths.addAll(Arrays.asList(mappingInfo.value()));
        }
        if (paths.isEmpty()) {
            paths.add("");
        }
        return paths;
    }

    private SpringController(TypeElement delegate, Set<String> paths, org.springframework.web.bind.annotation.RequestMapping mappingInfo, EnunciateSpringWebContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        this.paths = paths;
        this.mappingInfo = mappingInfo;
        TreeSet<String> consumes = new TreeSet<String>();
        if (mappingInfo != null && mappingInfo.consumes().length > 0) {
            for (String mt : mappingInfo.consumes()) {
                if (mt.startsWith("!")) continue;
                int colonIndex = mt.indexOf(59);
                if (colonIndex > 0) {
                    mt = mt.substring(0, colonIndex);
                }
                consumes.add(mt);
            }
        } else {
            consumes.add("*/*");
        }
        this.consumesMime = Collections.unmodifiableSet(consumes);
        TreeSet<String> produces = new TreeSet<String>();
        if (mappingInfo != null && mappingInfo.produces().length > 0) {
            for (String mt : mappingInfo.produces()) {
                if (mt.startsWith("!")) continue;
                int colonIndex = mt.indexOf(59);
                if (colonIndex > 0) {
                    mt = mt.substring(0, colonIndex);
                }
                produces.add(mt);
            }
        } else {
            produces.add("*/*");
        }
        this.producesMime = Collections.unmodifiableSet(produces);
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.requestMappings = Collections.unmodifiableList(this.getRequestMappings(delegate, new TypeVariableContext(), context));
    }

    protected List<RequestMapping> getRequestMappings(TypeElement delegate, TypeVariableContext variableContext, EnunciateSpringWebContext context) {
        TypeMirror superclass;
        if (delegate == null || delegate.getQualifiedName().toString().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<RequestMapping> requestMappings = new ArrayList<RequestMapping>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            RequestMethod[] requestMethods;
            if (IgnoreUtils.isIgnored((Element)executableElement) || (requestMethods = this.findRequestMethods(executableElement)) == null) continue;
            String[] consumes = this.findConsumes(executableElement);
            String[] produces = this.findProduces(executableElement);
            Set<String> subpaths = this.findSubpaths(executableElement);
            if (subpaths.isEmpty()) {
                subpaths.add("");
            }
            for (String path : this.getPaths()) {
                for (String subpath : subpaths) {
                    requestMappings.add(new RequestMapping(SpringController.extractPathComponents(path + subpath), requestMethods, consumes, produces, executableElement, this, variableContext, context));
                }
            }
            if (!requestMappings.isEmpty()) continue;
            requestMappings.add(new RequestMapping(new ArrayList<PathSegment>(), requestMethods, consumes, produces, executableElement, this, variableContext, context));
        }
        for (TypeMirror typeMirror : delegate.getInterfaces()) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            DeclaredType declared = (DeclaredType)typeMirror;
            TypeElement element = (TypeElement)declared.asElement();
            List<RequestMapping> interfaceMethods = this.getRequestMappings(element, variableContext.push(element.getTypeParameters(), declared.getTypeArguments()), context);
            for (RequestMapping interfaceMethod : interfaceMethods) {
                if (this.isOverridden((ExecutableElement)((Object)interfaceMethod), requestMappings)) continue;
                requestMappings.add(interfaceMethod);
            }
        }
        if (delegate.getKind() == ElementKind.CLASS && (superclass = delegate.getSuperclass()) instanceof DeclaredType && ((DeclaredType)superclass).asElement() != null) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement element = (TypeElement)declaredType.asElement();
            List<RequestMapping> superMethods = this.getRequestMappings(element, variableContext.push(element.getTypeParameters(), declaredType.getTypeArguments()), context);
            for (RequestMapping superMethod : superMethods) {
                if (this.isOverridden((ExecutableElement)((Object)superMethod), requestMappings)) continue;
                requestMappings.add(superMethod);
            }
        }
        return requestMappings;
    }

    private RequestMethod[] findRequestMethods(ExecutableElement method) {
        org.springframework.web.bind.annotation.RequestMapping requestMapping = method.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class);
        if (requestMapping != null) {
            return requestMapping.method();
        }
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (annotations != null) {
            for (AnnotationMirror annotationMirror : annotations) {
                Element annotationElement;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || (annotationElement = annotationType.asElement()) == null || (requestMapping = annotationElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class)) == null) continue;
                return requestMapping.method();
            }
        }
        return null;
    }

    private String[] findConsumes(ExecutableElement method) {
        org.springframework.web.bind.annotation.RequestMapping requestMapping = method.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class);
        if (requestMapping != null) {
            return requestMapping.consumes();
        }
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (annotations != null) {
            for (AnnotationMirror annotationMirror : annotations) {
                Element annotationElement;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || (annotationElement = annotationType.asElement()) == null || (requestMapping = annotationElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class)) == null) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    Object value;
                    if (!entry.getKey().getSimpleName().contentEquals("consumes") || !((value = entry.getValue().getValue()) instanceof List)) continue;
                    String[] consumes = new String[((List)value).size()];
                    for (int i = 0; i < ((List)value).size(); ++i) {
                        Object valueItem = ((List)value).get(i);
                        consumes[i] = valueItem.toString();
                    }
                    return consumes;
                }
            }
        }
        return null;
    }

    private Set<String> findSubpaths(ExecutableElement method) {
        org.springframework.web.bind.annotation.RequestMapping requestMapping = method.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class);
        if (requestMapping != null) {
            TreeSet<String> subpaths = new TreeSet<String>();
            try {
                subpaths.addAll(Arrays.asList(requestMapping.path()));
            }
            catch (IncompleteAnnotationException e) {
                // empty catch block
            }
            subpaths.addAll(Arrays.asList(requestMapping.value()));
            return subpaths;
        }
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (annotations != null) {
            for (AnnotationMirror annotationMirror : annotations) {
                Element annotationElement;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || (annotationElement = annotationType.asElement()) == null || (requestMapping = annotationElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class)) == null) continue;
                TreeSet<String> subpaths = new TreeSet<String>();
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    Object value;
                    if (!entry.getKey().getSimpleName().contentEquals("value") && !entry.getKey().getSimpleName().contentEquals("path") || !((value = entry.getValue().getValue()) instanceof List)) continue;
                    for (int i = 0; i < ((List)value).size(); ++i) {
                        AnnotationValue valueItem = (AnnotationValue)((List)value).get(i);
                        subpaths.add(String.valueOf(valueItem.getValue()));
                    }
                }
                return subpaths;
            }
        }
        return null;
    }

    private String[] findProduces(ExecutableElement method) {
        org.springframework.web.bind.annotation.RequestMapping requestMapping = method.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class);
        if (requestMapping != null) {
            return requestMapping.produces();
        }
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (annotations != null) {
            for (AnnotationMirror annotationMirror : annotations) {
                Element annotationElement;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || (annotationElement = annotationType.asElement()) == null || (requestMapping = annotationElement.getAnnotation(org.springframework.web.bind.annotation.RequestMapping.class)) == null) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    Object value;
                    if (!entry.getKey().getSimpleName().contentEquals("produces") || !((value = entry.getValue().getValue()) instanceof List)) continue;
                    String[] produces = new String[((List)value).size()];
                    for (int i = 0; i < ((List)value).size(); ++i) {
                        Object valueItem = ((List)value).get(i);
                        produces[i] = valueItem.toString();
                    }
                    return produces;
                }
            }
        }
        return null;
    }

    protected static List<PathSegment> extractPathComponents(String path) {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        if (path != null) {
            StringBuilder value = new StringBuilder();
            if (!path.startsWith("/")) {
                value.append("/");
            }
            StringBuilder variable = new StringBuilder();
            StringBuilder regexp = new StringBuilder();
            int inBrace = 0;
            boolean definingRegexp = false;
            for (int i = 0; i < path.length(); ++i) {
                char ch = path.charAt(i);
                if (ch == '{') {
                    if (++inBrace == 1) {
                        if (value.length() > 0) {
                            components.add(new PathSegment(value.toString(), variable.length() > 0 ? variable.toString() : null, regexp.length() > 0 ? regexp.toString() : null));
                        }
                        value = new StringBuilder();
                        variable = new StringBuilder();
                        regexp = new StringBuilder();
                    }
                } else if (ch == '}') {
                    if (--inBrace == 0) {
                        definingRegexp = false;
                    }
                } else {
                    if (inBrace == 1 && ch == ':') {
                        definingRegexp = true;
                        continue;
                    }
                    if (!definingRegexp && !Character.isWhitespace(ch) && inBrace > 0) {
                        variable.append(ch);
                    }
                }
                if (definingRegexp) {
                    regexp.append(ch);
                    continue;
                }
                if (Character.isWhitespace(ch)) continue;
                value.append(ch);
            }
            if (value.length() > 0) {
                components.add(new PathSegment(value.toString(), variable.length() > 0 ? variable.toString() : null, regexp.length() > 0 ? regexp.toString() : null));
            }
        }
        return components;
    }

    protected boolean isOverridden(ExecutableElement method, ArrayList<? extends ExecutableElement> resourceMethods) {
        Elements decls = this.env.getElementUtils();
        for (ExecutableElement executableElement : resourceMethods) {
            if (!decls.overrides(executableElement, method, (TypeElement)executableElement.getEnclosingElement())) continue;
            return true;
        }
        return false;
    }

    public EnunciateSpringWebContext getContext() {
        return this.context;
    }

    public final Set<String> getPaths() {
        return this.paths;
    }

    public Set<String> getConsumesMime() {
        return this.consumesMime;
    }

    public Set<String> getProducesMime() {
        return this.producesMime;
    }

    public List<RequestMapping> getRequestMappings() {
        return this.requestMappings;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<RequestMethod> getApplicableMethods() {
        RequestMethod[] methods;
        EnumSet<RequestMethod> applicableMethods = EnumSet.allOf(RequestMethod.class);
        if (this.mappingInfo != null && (methods = this.mappingInfo.method()).length > 0) {
            applicableMethods.retainAll(Arrays.asList(methods));
        }
        return applicableMethods;
    }

    public Set<String> getSecurityRoles() {
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        return roles;
    }
}

