/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.DocComment;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.ParamDocComment;
import com.webcohesion.enunciate.javac.javadoc.ReturnDocComment;
import com.webcohesion.enunciate.javac.javadoc.StaticDocComment;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResponseHeader;
import com.webcohesion.enunciate.metadata.rs.ResponseHeaders;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.metadata.rs.Warnings;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.ExplicitRequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.PathContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMappingAdvice;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameterFactory;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterType;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.modules.spring_web.model.SpringControllerAdvice;
import com.webcohesion.enunciate.modules.spring_web.model.util.RSParamDocComment;
import com.webcohesion.enunciate.modules.spring_web.model.util.ReturnWrappedDocComment;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.IgnoreUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

public class RequestMapping
extends DecoratedExecutableElement
implements HasFacets,
PathContext {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final EnunciateSpringWebContext context;
    private final List<PathSegment> pathSegments;
    private final String label;
    private final Set<String> httpMethods;
    private final Set<String> consumesMediaTypes;
    private final Set<String> producesMediaTypes;
    private final SpringController parent;
    private final Set<RequestParameter> requestParameters;
    private final ResourceEntityParameter entityParameter;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<? extends ResponseCode> statusCodes;
    private final List<? extends ResponseCode> warnings;
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private final ResourceRepresentationMetadata representationMetadata;
    private final Set<Facet> facets = new TreeSet<Facet>();

    public RequestMapping(List<PathSegment> pathSegments, RequestMethod[] methods, String[] consumesInfo, String[] producesInfo, ExecutableElement delegate, SpringController parent, TypeVariableContext variableContext, EnunciateSpringWebContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        DecoratedProcessingEnvironment env;
        ResponseCode rc;
        ResponseStatus responseStatus;
        DecoratedTypeMirror returnType;
        this.context = context;
        this.pathSegments = pathSegments;
        EnumSet<RequestMethod> httpMethods = EnumSet.allOf(RequestMethod.class);
        if (methods.length > 0) {
            httpMethods.retainAll(Arrays.asList(methods));
        }
        httpMethods.retainAll(parent.getApplicableMethods());
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException(parent.getQualifiedName() + "." + this.getSimpleName() + ": no applicable request methods.");
        }
        this.httpMethods = new TreeSet<String>();
        for (RequestMethod httpMethod : httpMethods) {
            this.httpMethods.add(httpMethod.name());
        }
        Set<Object> consumes = new TreeSet();
        if (consumesInfo != null && consumesInfo.length > 0) {
            for (String mediaType : consumesInfo) {
                if (mediaType.startsWith("!")) continue;
                int colonIndex = mediaType.indexOf(59);
                if (colonIndex > 0) {
                    mediaType = mediaType.substring(0, colonIndex);
                }
                consumes.add(mediaType);
            }
            if (consumes.isEmpty()) {
                consumes.add("*/*");
            }
        } else {
            consumes = parent.getConsumesMime();
        }
        this.consumesMediaTypes = consumes;
        Set<Object> produces = new TreeSet();
        if (producesInfo != null && producesInfo.length > 0) {
            for (String mediaType : producesInfo) {
                if (mediaType.startsWith("!")) continue;
                int colonIndex = mediaType.indexOf(59);
                if (colonIndex > 0) {
                    mediaType = mediaType.substring(0, colonIndex);
                }
                produces.add(mediaType);
            }
            if (produces.isEmpty()) {
                produces.add("*/*");
            }
        } else {
            produces = parent.getProducesMime();
        }
        this.producesMediaTypes = produces;
        String label = null;
        ResourceLabel resourceLabel = delegate.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && "##default".equals(label = resourceLabel.value())) {
            label = null;
        }
        ResourceEntityParameter entityParameter = null;
        ResourceRepresentationMetadata outputPayload = null;
        TreeSet<RequestParameter> requestParameters = new TreeSet<RequestParameter>();
        ArrayList<? extends ResponseCode> statusCodes = new ArrayList<ResponseCode>();
        ArrayList<? extends ResponseCode> warnings = new ArrayList<ResponseCode>();
        Set<SpringControllerAdvice> advice = this.context.getAdvice();
        for (SpringControllerAdvice controllerAdvice : advice) {
            List<RequestMappingAdvice> requestAdvice = controllerAdvice.findRequestMappingAdvice(this);
            for (RequestMappingAdvice mappingAdvice : requestAdvice) {
                entityParameter = mappingAdvice.getEntityParameter();
                outputPayload = mappingAdvice.getRepresentationMetadata();
                requestParameters.addAll(mappingAdvice.getRequestParameters());
                statusCodes.addAll(mappingAdvice.getStatusCodes());
                warnings.addAll(mappingAdvice.getWarnings());
                this.responseHeaders.putAll(mappingAdvice.getResponseHeaders());
            }
        }
        for (VariableElement parameterDeclaration : this.getParameters()) {
            if (IgnoreUtils.isIgnored((Element)parameterDeclaration)) continue;
            if (parameterDeclaration.getAnnotation(RequestBody.class) != null || this.isImplicitRequestBody(parameterDeclaration.asType())) {
                entityParameter = new ResourceEntityParameter(parameterDeclaration, variableContext, context);
                continue;
            }
            requestParameters.addAll(RequestParameterFactory.getRequestParameters((ExecutableElement)((Object)this), parameterDeclaration, this));
        }
        TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
        JavaDoc localDoc = new JavaDoc(this.getDocComment(), null, null, this.env);
        if (hintInfo != null) {
            returnType = (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hintInfo, (DecoratedProcessingEnvironment)this.env, null);
            if (returnType != null) {
                returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
            }
        } else {
            boolean returnsResponseBody;
            returnType = (DecoratedTypeMirror)this.getReturnType();
            if (returnType instanceof DecoratedDeclaredType && (returnType.isInstanceOf(Callable.class) || returnType.isInstanceOf("org.springframework.web.context.request.async.DeferredResult") || returnType.isInstanceOf("org.springframework.util.concurrent.ListenableFuture"))) {
                List typeArgs = ((DecoratedDeclaredType)returnType).getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (DecoratedProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            boolean bl = returnsResponseBody = this.getAnnotation(ResponseBody.class) != null || parent.getAnnotation(ResponseBody.class) != null || parent.getAnnotation(RestController.class) != null;
            if (returnType instanceof DecoratedDeclaredType && returnType.isInstanceOf("org.springframework.http.HttpEntity")) {
                DecoratedDeclaredType entity = (DecoratedDeclaredType)returnType;
                List typeArgs = entity.getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (DecoratedProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            } else if (!returnsResponseBody) {
                returnType = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            if (localDoc.get((Object)"returnWrapped") != null) {
                TypeElement type;
                String returnWrapped = (String)((JavaDoc.JavaDocTagList)localDoc.get((Object)"returnWrapped")).get(0);
                String fqn = returnWrapped.substring(0, JavaDoc.indexOfFirstWhitespace((String)returnWrapped)).trim();
                boolean array = false;
                if (fqn.endsWith("[]")) {
                    array = true;
                    fqn = fqn.substring(0, fqn.length() - 2);
                }
                if ((type = this.env.getElementUtils().getTypeElement(fqn)) != null) {
                    returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), (DecoratedProcessingEnvironment)this.env);
                    if (array) {
                        returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.env.getTypeUtils().getArrayType((TypeMirror)returnType), (DecoratedProcessingEnvironment)this.env);
                    }
                    returnType.setDeferredDocComment((DocComment)new ReturnWrappedDocComment(this));
                } else {
                    this.getContext().getContext().getLogger().info("Invalid @returnWrapped type: \"%s\" (doesn't resolve to a type).", new Object[]{fqn});
                }
            }
            returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)variableContext.resolveTypeVariables((TypeMirror)returnType, (ProcessingEnvironment)this.env), (DecoratedProcessingEnvironment)this.env);
            returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
        }
        outputPayload = returnType == null || returnType.isVoid() ? outputPayload : new ResourceRepresentationMetadata(returnType);
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"RequestHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), doc, header, ResourceParameterType.HEADER, context));
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"RequestHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), doc, header, ResourceParameterType.HEADER, context));
            }
        }
        RequestHeaders requestHeaders = (RequestHeaders)this.getAnnotation(RequestHeaders.class);
        if (requestHeaders != null) {
            for (RequestHeader header : requestHeaders.value()) {
                requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), header.description(), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        List inheritedRequestHeaders = AnnotationUtils.getAnnotations(RequestHeaders.class, (Element)((Object)parent));
        for (RequestHeaders inheritedRequestHeader : inheritedRequestHeaders) {
            for (RequestHeader header : inheritedRequestHeader.value()) {
                requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), header.description(), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : codes.value()) {
                ResponseCode rc2 = new ResponseCode(this);
                rc2.setCode(code.code());
                rc2.setCondition(code.condition());
                for (ResponseHeader header : code.additionalHeaders()) {
                    rc2.setAdditionalHeader(header.name(), header.description());
                }
                rc2.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (DecoratedProcessingEnvironment)this.env, null));
                statusCodes.add(rc2);
            }
        }
        if ((responseStatus = (ResponseStatus)this.getAnnotation(ResponseStatus.class)) != null) {
            HttpStatus code = responseStatus.value();
            if (code == HttpStatus.INTERNAL_SERVER_ERROR) {
                try {
                    code = responseStatus.code();
                }
                catch (IncompleteAnnotationException e) {
                    // empty catch block
                }
            }
            ResponseCode rc3 = new ResponseCode(this);
            rc3.setCode(code.value());
            String reason = responseStatus.reason();
            if (!reason.isEmpty()) {
                rc3.setCondition(reason);
            }
            statusCodes.add(rc3);
        }
        List inheritedStatusCodes = AnnotationUtils.getAnnotations(StatusCodes.class, (Element)((Object)parent));
        for (StatusCodes inheritedStatusCode : inheritedStatusCodes) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedStatusCode.value()) {
                ResponseCode rc4 = new ResponseCode(this);
                rc4.setCode(code.code());
                rc4.setCondition(code.condition());
                for (ResponseHeader header : code.additionalHeaders()) {
                    rc4.setAdditionalHeader(header.name(), header.description());
                }
                rc4.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (DecoratedProcessingEnvironment)this.env, null));
                statusCodes.add(rc4);
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"HTTP");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc5 = new ResponseCode(this);
                    rc5.setCode(Integer.parseInt(code));
                    rc5.setCondition(doc);
                    statusCodes.add(rc5);
                }
                catch (NumberFormatException e) {}
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTP", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        Warnings warningInfo = (Warnings)this.getAnnotation(Warnings.class);
        if (warningInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : warningInfo.value()) {
                ResponseCode rc6 = new ResponseCode(this);
                rc6.setCode(code.code());
                rc6.setCondition(code.condition());
                warnings.add(rc6);
            }
        }
        List inheritedWarnings = AnnotationUtils.getAnnotations(Warnings.class, (Element)((Object)parent));
        for (Warnings inheritedWarning : inheritedWarnings) {
            for (Object code : inheritedWarning.value()) {
                ResponseCode rc7 = new ResponseCode(this);
                rc7.setCode(code.code());
                rc7.setCondition(code.condition());
                warnings.add(rc7);
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"HTTPWarning");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    warnings.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTPWarning", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                Object code;
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc8 = new ResponseCode(this);
                    rc8.setCode(Integer.parseInt((String)code));
                    rc8.setCondition(doc);
                    warnings.add(rc8);
                }
                catch (NumberFormatException e) {}
            }
        }
        ResponseHeaders responseHeaders = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class);
        if (responseHeaders != null) {
            for (ResponseHeader header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        List inheritedResponseHeaders = AnnotationUtils.getAnnotations(ResponseHeaders.class, (Element)((Object)parent));
        for (ResponseHeaders inheritedResponseHeader : inheritedResponseHeaders) {
            for (ResponseHeader header : inheritedResponseHeader.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"ResponseHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                this.responseHeaders.put(header, doc);
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"ResponseHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                this.responseHeaders.put(header, doc);
            }
        }
        if (outputPayload == null && this.getJavaDoc().get((Object)"responseExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            outputPayload = new ResourceRepresentationMetadata((TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), (DocComment)new StaticDocComment(""));
        }
        if (entityParameter == null && this.getJavaDoc().get((Object)"requestExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            entityParameter = new ResourceEntityParameter((Element)((Object)this), (TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), env);
        }
        this.entityParameter = entityParameter;
        this.requestParameters = requestParameters;
        this.label = label;
        this.parent = parent;
        this.statusCodes = statusCodes;
        this.warnings = warnings;
        this.representationMetadata = outputPayload;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(parent.getFacets());
    }

    protected ParamDocComment createParamDocComment(VariableElement param) {
        return new RSParamDocComment(this, param.getSimpleName().toString());
    }

    @Override
    public EnunciateSpringWebContext getContext() {
        return this.context;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public String getFullpath() {
        StringBuilder builder = new StringBuilder();
        for (PathSegment pathSegment : this.getPathSegments()) {
            builder.append(pathSegment.getValue());
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public SpringController getParent() {
        return this.parent;
    }

    public Set<String> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public Set<String> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public Set<RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        SpringController parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }

    private boolean isImplicitRequestBody(TypeMirror parameterType) {
        DecoratedTypeMirror type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameterType, (DecoratedProcessingEnvironment)this.env);
        return type.isInstanceOf(InputStream.class) || type.isInstanceOf(Reader.class) || type.isInstanceOf("javax.servlet.ServletRequest") || type.isInstanceOf("javax.servlet.http.HttpServletRequest");
    }
}

