/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.c_client;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.DefaultRegistrationContext;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.c_client.CXMLClientObjectWrapper;
import com.webcohesion.enunciate.modules.c_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.c_client.NameForEnumConstantMethod;
import com.webcohesion.enunciate.modules.c_client.NameForTypeDefinitionMethod;
import com.webcohesion.enunciate.modules.c_client.PrefixMethod;
import com.webcohesion.enunciate.modules.c_client.XmlFunctionIdentifierMethod;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.Element;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBCodeErrors;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.modules.jaxb.util.AccessorOverridesAnotherMethod;
import com.webcohesion.enunciate.modules.jaxb.util.FindRootElementMethod;
import com.webcohesion.enunciate.modules.jaxb.util.ReferencedNamespacesMethod;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class CXMLClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule {
    private static final Pattern SCRUB_PATTERN = Pattern.compile("\\W");
    JaxbModule jaxbModule;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "c-xml-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JaxbModule) {
                    CXMLClientModule.this.jaxbModule = (JaxbModule)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    CXMLClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jaxb, optional jaxrs";
            }
        });
    }

    public static String scrubIdentifier(String identifier) {
        return identifier == null ? null : SCRUB_PATTERN.matcher(identifier).replaceAll("_");
    }

    public void call(EnunciateContext context) {
        if (this.jaxbModule == null || this.jaxbModule.getJaxbContext() == null || this.jaxbModule.getJaxbContext().getSchemas().isEmpty()) {
            this.info("No JAXB XML data types: C XML client will not be generated.", new Object[0]);
            return;
        }
        if (this.usesUnmappableElements()) {
            this.warn("Web service API makes use of elements that cannot be handled by the C XML client. C XML client will not be generated.", new Object[0]);
            return;
        }
        List namingConflicts = JAXBCodeErrors.findConflictingAccessorNamingErrors((EnunciateJaxbContext)this.jaxbModule.getJaxbContext());
        if (namingConflicts != null && !namingConflicts.isEmpty()) {
            this.error("JAXB naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or two of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            this.error("3. Tell JAXB to use a different process for detecting accessors using the @XmlAccessorType annotation.", new Object[0]);
            throw new EnunciateException("JAXB naming conflicts detected.");
        }
        File srcDir = this.getSourceDir();
        srcDir.mkdirs();
        HashMap<String, Object> model = new HashMap<String, Object>();
        String slug = this.getSlug();
        Map ns2prefix = this.jaxbModule.getJaxbContext().getNamespacePrefixes();
        NameForTypeDefinitionMethod nameForTypeDefinition = new NameForTypeDefinitionMethod(this.getTypeDefinitionNamePattern(), slug, ns2prefix);
        model.put("nameForTypeDefinition", nameForTypeDefinition);
        model.put("nameForEnumConstant", new NameForEnumConstantMethod(this.getEnumConstantNamePattern(), slug, ns2prefix));
        TreeMap<String, String> conversions = new TreeMap<String, String>();
        for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
            for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                if (typeDefinition.isEnum()) {
                    conversions.put(typeDefinition.getQualifiedName().toString(), "enum " + nameForTypeDefinition.calculateName(typeDefinition));
                    continue;
                }
                conversions.put(typeDefinition.getQualifiedName().toString(), "struct " + nameForTypeDefinition.calculateName(typeDefinition));
            }
        }
        ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(conversions, this.jaxbModule.getJaxbContext());
        model.put("classnameFor", (Object)classnameFor);
        String sourceFileName = this.getSourceFileName(slug);
        model.put("cFileName", sourceFileName);
        model.put("separateCommonCode", this.isSeparateCommonCode());
        model.put("findRootElement", new FindRootElementMethod(this.jaxbModule.getJaxbContext()));
        model.put("referencedNamespaces", new ReferencedNamespacesMethod(this.jaxbModule.getJaxbContext()));
        model.put("prefix", new PrefixMethod(ns2prefix));
        model.put("xmlFunctionIdentifier", new XmlFunctionIdentifierMethod(ns2prefix));
        model.put("accessorOverridesAnother", new AccessorOverridesAnotherMethod());
        model.put("filename", sourceFileName);
        model.put("file", new FileDirective(srcDir, this.enunciate.getLogger()));
        model.put("schemas", this.jaxbModule.getJaxbContext().getSchemas().values());
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        if (!this.isUpToDateWithSources(srcDir)) {
            this.debug("Generating the C data structures and (de)serialization functions...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            try {
                this.processTemplate(apiTemplate, model);
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping C code generation because everything appears up-to-date.", new Object[0]);
        }
        ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "c.client.library", "C Client Library");
        FileArtifact sourceScript = new FileArtifact(this.getName(), "c.client", new File(srcDir, sourceFileName));
        sourceScript.setArtifactType(ArtifactType.sources);
        sourceScript.setPublic(false);
        String description = this.readResource("library_description.fmt", model, nameForTypeDefinition);
        artifactBundle.setDescription(description);
        artifactBundle.addArtifact(sourceScript);
        if (this.isSeparateCommonCode()) {
            FileArtifact commonSourceHeader = new FileArtifact(this.getName(), "c.common.client", new File(srcDir, "enunciate-common.c"));
            commonSourceHeader.setPublic(false);
            commonSourceHeader.setArtifactType(ArtifactType.sources);
            commonSourceHeader.setDescription("Common code needed for all projects.");
            artifactBundle.addArtifact(commonSourceHeader);
        }
        this.enunciate.addArtifact((Artifact)artifactBundle);
    }

    protected boolean usesUnmappableElements() {
        boolean usesUnmappableElements = false;
        if (this.jaxbModule != null && this.jaxbModule.getJaxbContext() != null && !this.jaxbModule.getJaxbContext().getSchemas().isEmpty()) {
            for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
                for (TypeDefinition complexType : schemaInfo.getTypeDefinitions()) {
                    for (Attribute attribute : complexType.getAttributes()) {
                        if (attribute.isXmlList()) {
                            this.info("%s: The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.", new Object[]{this.positionOf((javax.lang.model.element.Element)attribute)});
                        }
                        if (!attribute.isCollectionType() || !attribute.isBinaryData()) continue;
                        this.warn("%s: The C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the C module.", new Object[]{this.positionOf((javax.lang.model.element.Element)attribute)});
                        usesUnmappableElements = true;
                    }
                    if (complexType.getValue() != null) {
                        if (complexType.getValue().isXmlList()) {
                            this.info("%s: The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.", new Object[]{this.positionOf((javax.lang.model.element.Element)complexType.getValue())});
                        }
                        if (complexType.getValue().isCollectionType() && complexType.getValue().isBinaryData()) {
                            this.warn("%s: The C client code doesn't support a collection of items that are binary data.", new Object[]{this.positionOf((javax.lang.model.element.Element)complexType.getValue())});
                            usesUnmappableElements = true;
                        }
                    }
                    for (Element element : complexType.getElements()) {
                        if (element.isXmlList()) {
                            this.info("%s: The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                        }
                        if (element.getAccessorType() instanceof MapType && !element.isAdapted()) {
                            this.warn("%s: The C client doesn't have a built-in way of serializing a Map. Use @XmlJavaTypeAdapter to supply your own adapter for the Map.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                            usesUnmappableElements = true;
                        }
                        if (!element.isCollectionType()) continue;
                        if (element.getChoices().size() > 1) {
                            this.info("%s: The C client code doesn't fully support multiple choices for a collection. It has to separate each choice into its own array. This makes the C API a bit awkward to use and makes it impossible to preserve the order of the collection. If order is relevant, consider breaking out the choices into their own collection or otherwise refactoring the API.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                        }
                        if (element.isBinaryData()) {
                            this.warn("%s: The C client code doesn't support a collection of items that are binary data.", new Object[]{this.positionOf((javax.lang.model.element.Element)element)});
                            usesUnmappableElements = true;
                        }
                        for (Element choice : element.getChoices()) {
                            if (!choice.isNillable()) continue;
                            this.info("%s: The C client code doesn't support nillable items in a collection (the nil items will be skipped). This may cause confusion to C consumers.", new Object[]{this.positionOf((javax.lang.model.element.Element)choice)});
                        }
                    }
                }
            }
        }
        return usesUnmappableElements;
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setLocale(new Locale("en", "US"));
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new CXMLClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected String readResource(String resource, Map<String, Object> model, NameForTypeDefinitionMethod nameForTypeDefinition) {
        Method exampleResource = this.findExampleResourceMethod();
        if (exampleResource != null) {
            TypeDefinition typeDefinition = this.findRequestElement(exampleResource);
            if (typeDefinition != null) {
                model.put("input_element_name", nameForTypeDefinition.calculateName(typeDefinition));
            }
            if ((typeDefinition = this.findResponseElement(exampleResource)) != null) {
                model.put("output_element_name", nameForTypeDefinition.calculateName(typeDefinition));
            }
        }
        URL res = CXMLClientModule.class.getResource(resource);
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    private TypeDefinition findRequestElement(Method exampleResource) {
        if (exampleResource.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : exampleResource.getRequestEntity().getMediaTypes()) {
                XmlType xmlType;
                DataTypeReference dataType;
                if (!"XML".equals(mediaTypeDescriptor.getSyntax()) || !((dataType = mediaTypeDescriptor.getDataType()) instanceof DataTypeReferenceImpl) || !((xmlType = ((DataTypeReferenceImpl)dataType).getXmlType()) instanceof XmlClassType)) continue;
                return ((XmlClassType)xmlType).getTypeDefinition();
            }
        }
        return null;
    }

    private TypeDefinition findResponseElement(Method exampleResource) {
        if (exampleResource.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : exampleResource.getResponseEntity().getMediaTypes()) {
                XmlType xmlType;
                DataTypeReference dataType;
                if (!"XML".equals(mediaTypeDescriptor.getSyntax()) || !((dataType = mediaTypeDescriptor.getDataType()) instanceof DataTypeReferenceImpl) || !((xmlType = ((DataTypeReferenceImpl)dataType).getXmlType()) instanceof XmlClassType)) continue;
                return ((XmlClassType)xmlType).getTypeDefinition();
            }
        }
        return null;
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups((ApiRegistrationContext)new DefaultRegistrationContext());
        for (ResourceGroup resourceGroup : resourceGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                for (Method method : resource.getMethods()) {
                    if (!this.hasXmlResponseEntity(method)) continue;
                    if (this.hasXmlRequestEntity(method)) {
                        return method;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getSourceFileName(String label) {
        return label + ".c";
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    protected URL getTemplateURL(String template) {
        return CXMLClientModule.class.getResource(template);
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public String getTypeDefinitionNamePattern() {
        return this.config.getString("[@typeDefinitionNamePattern]", "%1$s_%2$s_%3$s");
    }

    public String getEnumConstantNamePattern() {
        return this.config.getString("[@enumConstantNamePattern]", "%1$S_%2$S_%3$S_%9$S");
    }

    public boolean isSeparateCommonCode() {
        return this.config.getBoolean("[@separateCommonCode]", true);
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

