/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.util.Base64;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Base64UrlUtil {
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    private Base64UrlUtil() {
    }

    public static @NonNull byte[] decode(@NonNull String source) {
        AssertUtil.notNull(source, "source must not be null");
        return decoder.decode(source);
    }

    public static @NonNull byte[] decode(@NonNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return decoder.decode(source);
    }

    public static @NonNull byte[] encode(@NonNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return encoder.encode(source);
    }

    public static @NonNull String encodeToString(@NonNull byte[] source) {
        AssertUtil.notNull(source, "source must not be null");
        return encoder.encodeToString(source);
    }
}

