/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AttestationObjectConverter {
    private static final String SOURCE_NULL_CHECK_MESSAGE = "source must not be null";
    private final CborConverter cborConverter;

    public AttestationObjectConverter(@NonNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
    }

    public @Nullable AttestationObject convert(@NonNull String source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            byte[] value = Base64UrlUtil.decode((String)source);
            return this.convert(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @Nullable AttestationObject convert(@NonNull byte[] source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            return this.cborConverter.readValue(source, AttestationObject.class);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @NonNull byte[] convertToBytes(@NonNull AttestationObject source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            return this.cborConverter.writeValueAsBytes(source);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @NonNull String convertToBase64urlString(@NonNull AttestationObject source) {
        try {
            byte[] bytes = this.convertToBytes(source);
            return Base64UrlUtil.encodeToString((byte[])bytes);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @Nullable byte[] extractAuthenticatorData(@NonNull byte[] attestationObject) {
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        JsonNode authData = this.cborConverter.readTree(attestationObject).get("authData");
        return JacksonUtil.binaryValue(authData);
    }

    public @Nullable byte[] extractAttestationStatement(@NonNull byte[] attestationObject) {
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        JsonNode attStmt = this.cborConverter.readTree(attestationObject).get("attStmt");
        return this.cborConverter.writeValueAsBytes(attStmt);
    }
}

