/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.data.extension.UvmEntry;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UvmEntries
extends AbstractList<UvmEntry>
implements Serializable {
    private final int size;
    private final UvmEntry[] array;

    @JsonCreator
    public UvmEntries(@NonNull List<UvmEntry> value) {
        AssertUtil.notNull(value, (String)"value must not be null");
        this.size = value.size();
        this.array = value.toArray(new UvmEntry[this.size]);
    }

    public UvmEntries() {
        this(Collections.emptyList());
    }

    @Override
    public @NonNull UvmEntry get(int index) {
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UvmEntries that = (UvmEntries)o;
        return this.size == that.size && Arrays.equals(this.array, that.array);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.array);
        return result;
    }
}

