/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AttestationConveyancePreference
implements Serializable {
    public static final AttestationConveyancePreference NONE = new AttestationConveyancePreference("none");
    public static final AttestationConveyancePreference INDIRECT = new AttestationConveyancePreference("indirect");
    public static final AttestationConveyancePreference DIRECT = new AttestationConveyancePreference("direct");
    public static final AttestationConveyancePreference ENTERPRISE = new AttestationConveyancePreference("enterprise");
    private final String value;

    private AttestationConveyancePreference(@NonNull String value) {
        this.value = value;
    }

    @JsonCreator
    public static @NonNull AttestationConveyancePreference create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "none": {
                return NONE;
            }
            case "indirect": {
                return INDIRECT;
            }
            case "direct": {
                return DIRECT;
            }
            case "enterprise": {
                return ENTERPRISE;
            }
        }
        return new AttestationConveyancePreference(value);
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationConveyancePreference that = (AttestationConveyancePreference)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

