/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.certpath;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.CertificateException;
import com.webauthn4j.validator.exception.TrustAnchorNotFoundException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.Set;

public abstract class CertPathTrustworthinessValidatorBase
implements CertPathTrustworthinessValidator {
    private boolean fullChainProhibited = false;

    @Override
    public void validate(AAGUID aaguid, CertificateBaseAttestationStatement attestationStatement) {
        PKIXCertPathValidatorResult result;
        CertPath certPath = attestationStatement.getX5c().createCertPath();
        Set<TrustAnchor> trustAnchors = this.resolveTrustAnchors(aaguid);
        if (trustAnchors.isEmpty()) {
            throw new TrustAnchorNotFoundException("TrustAnchors are not found for AAGUID: " + aaguid.toString());
        }
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        certPathParameters.setPolicyQualifiersRejected(false);
        certPathParameters.setRevocationEnabled(false);
        try {
            result = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("invalid cert path", e);
        }
        if (this.fullChainProhibited && certPath.getCertificates().contains(result.getTrustAnchor().getTrustedCert())) {
            throw new CertificateException("`certpath` must not contain full chain.");
        }
    }

    protected abstract Set<TrustAnchor> resolveTrustAnchors(AAGUID var1);

    public boolean isFullChainProhibited() {
        return this.fullChainProhibited;
    }

    public void setFullChainProhibited(boolean fullChainProhibited) {
        this.fullChainProhibited = fullChainProhibited;
    }
}

