/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.KeyStoreException;
import com.webauthn4j.anchor.TrustAnchorsProvider;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import java.security.KeyStore;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyStoreTrustAnchorsProvider
implements TrustAnchorsProvider {
    private KeyStore keyStore;

    @Override
    public Map<AAGUID, Set<TrustAnchor>> provide() {
        return this.loadTrustAnchors();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    private void checkConfig() {
        AssertUtil.notNull((Object)this.keyStore, (String)"keyStore must not be null");
    }

    private Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        this.checkConfig();
        KeyStore keyStoreObject = this.getKeyStore();
        try {
            ArrayList<String> aliases = Collections.list(keyStoreObject.aliases());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (String alias : aliases) {
                X509Certificate certificate = (X509Certificate)keyStoreObject.getCertificate(alias);
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
            return Collections.singletonMap(AAGUID.NULL, trustAnchors);
        }
        catch (java.security.KeyStoreException e) {
            throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
        }
    }
}

