/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import java.util.function.Function;

public class CopyOnWriteRef<T> {
    private T myValue;
    private int myReferenceCount;
    private Function<T, T> myCloner;

    public CopyOnWriteRef(T value, Function<T, T> cloner) {
        this.myValue = value;
        this.myReferenceCount = 0;
        this.myCloner = cloner;
    }

    public T getPeek() {
        return this.myValue;
    }

    public T getImmutable() {
        if (this.myValue != null) {
            ++this.myReferenceCount;
        }
        return this.myValue;
    }

    public T getMutable() {
        if (this.myReferenceCount > 0) {
            this.myValue = this.myCloner.apply(this.myValue);
            this.myReferenceCount = 0;
        }
        return this.myValue;
    }

    public void setValue(T value) {
        this.myReferenceCount = 0;
        this.myValue = this.myCloner.apply(value);
    }

    public boolean isMutable() {
        return this.myReferenceCount == 0;
    }
}

