/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.osgi.resources;

/**
 * Used to declare a Vaadin Theme for use in OSGi. The theme is expected to be
 * in the same OSGi bundle as the class implementing this interface, under the
 * path "/VAADIN/themes/{themeName}" where {themeName} is what is returned by
 * {@link OsgiVaadinTheme#getName()}.
 * <p>
 * To publish a theme, an implementation of this interface needs to be
 * registered as an OSGi service, which makes
 * <code>VaadinResourceTrackerComponent</code> automatically publish the theme
 * with the given name.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 */
public interface OsgiVaadinTheme extends OsgiVaadinResource {
    /**
     * Return the theme name to publish for OSGi.
     *
     * @return theme name, not null
     */
    @Override
    public String getName();

    public static OsgiVaadinTheme create(final String name) {
        return new OsgiVaadinTheme() {
            @Override
            public String getName() {
                return name;
            }
        };
    }
}
