/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.select.FieldValidationUtil;
import com.vaadin.flow.component.select.VaadinItem;
import com.vaadin.flow.component.select.generated.GeneratedVaadinSelect;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@JavaScript(value="frontend://selectConnector.js")
public class Select<T>
extends GeneratedVaadinSelect<Select<T>, T>
implements HasDataProvider<T>,
HasItemsAndComponents<T>,
HasSize,
HasValidation,
SingleSelect<Select<T>, T>,
HasHelper {
    public static final String LABEL_ATTRIBUTE = "label";
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private final InternalListBox listBox = new InternalListBox();
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private ComponentRenderer<? extends Component, T> itemRenderer;
    private SerializablePredicate<T> itemEnabledProvider = null;
    private ItemLabelGenerator<T> itemLabelGenerator = null;
    private final PropertyChangeListener validationListener = this::validateSelectionEnabledState;
    private Registration validationRegistration;
    private Registration dataProviderListenerRegistration;
    private boolean resetPending = true;
    private boolean emptySelectionAllowed;
    private String emptySelectionCaption;
    private VaadinItem<T> emptySelectionItem;

    private static <T> T presentationToModel(Select<T> select, String presentation) {
        if (!select.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)select.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(Select<T> select, T model) {
        if (model == null) {
            return "";
        }
        if (!select.keyMapper.has(model)) {
            return null;
        }
        return select.keyMapper.key(model);
    }

    public Select() {
        super(null, null, String.class, Select::presentationToModel, Select::modelToPresentation);
        this.getElement().setProperty("invalid", false);
        this.getElement().setProperty("opened", false);
        this.setPresentationValue(null);
        this.getElement().appendChild(new Element[]{this.listBox.getElement()});
        this.registerValidation();
    }

    public Select(T ... items) {
        this();
        this.setItems(items);
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = renderer;
        this.refreshItems();
    }

    public void setTextRenderer(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator);
        this.setRenderer((ComponentRenderer<? extends Component, T>)new TextRenderer(itemLabelGenerator));
    }

    public void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        if (this.isEmptySelectionAllowed() == emptySelectionAllowed) {
            return;
        }
        if (this.isEmptySelectionAllowed()) {
            this.removeEmptySelectionItem();
        } else {
            this.addEmptySelectionItem();
        }
        this.emptySelectionAllowed = emptySelectionAllowed;
    }

    public boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public void setEmptySelectionCaption(String emptySelectionCaption) {
        Objects.requireNonNull(emptySelectionCaption, "Empty selection caption must not be null");
        this.emptySelectionCaption = emptySelectionCaption;
        if (this.emptySelectionItem != null) {
            this.updateItem(this.emptySelectionItem);
        }
    }

    public String getEmptySelectionCaption() {
        return this.emptySelectionCaption == null ? "" : this.emptySelectionCaption;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = itemEnabledProvider;
        this.refreshItems();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
        this.refreshItems();
    }

    public String getPlaceholder() {
        return super.getPlaceholderString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return super.getLabelString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return super.isAutofocusBoolean();
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider = dataProvider;
        this.reset();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener(this::onDataChange);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.setDisabled(!enabled);
        this.getItems().forEach(this::updateItemEnabled);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return super.isInvalidBoolean();
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                super.add(new Component[]{component});
                continue;
            }
            this.listBox.add(new Component[]{component});
        }
    }

    public void addComponents(T afterItem, Component ... components) {
        this.listBox.addComponents(afterItem, components);
    }

    public void prependComponents(T beforeItem, Component ... components) {
        this.listBox.prependComponents(beforeItem, components);
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAtIndex(index, component);
        } else {
            this.listBox.addComponentAtIndex(index, component);
        }
    }

    public void addComponentAsFirst(Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAsFirst(component);
        } else {
            this.listBox.addComponentAsFirst(component);
        }
    }

    @Override
    public void addToPrefix(Component ... components) {
        super.addToPrefix(components);
    }

    public Stream<Component> getChildren() {
        return Stream.concat(super.getChildren().filter(component -> component != this.listBox), this.listBox.getChildren().filter(component -> !(component instanceof VaadinItem)));
    }

    @Override
    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                super.remove(component);
                continue;
            }
            this.listBox.remove(components);
        }
    }

    @Override
    public void removeAll() {
        this.getChildren().forEach(xva$0 -> this.remove((Component)xva$0));
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty("value");
        Object item = this.keyMapper.get(selectedKey);
        if (item == null) {
            return this.isEmptySelectionAllowed() && this.isItemEnabled(item);
        }
        return this.isItemEnabled(item);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        FieldValidationUtil.disableClientValidation(this);
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            ui.getPage().executeJavaScript("window.Vaadin.Flow.selectConnector.initLazy($0)", new Serializable[]{this.getElement()});
            this.resetPending = false;
        });
    }

    private boolean isItemEnabled(T item) {
        return this.itemEnabledProvider == null || this.itemEnabledProvider.test(item);
    }

    private Component createItem(T bean) {
        VaadinItem<T> item = new VaadinItem<T>(this.keyMapper.key(bean), bean);
        this.updateItem(item);
        return item;
    }

    private void updateItem(VaadinItem<T> vaadinItem) {
        vaadinItem.removeAll();
        T item = vaadinItem.getItem();
        if (vaadinItem == this.emptySelectionItem) {
            vaadinItem.setText(this.emptySelectionCaption);
        } else if (this.getItemRenderer() != null) {
            vaadinItem.add(new Component[]{this.getItemRenderer().createComponent(item)});
        } else if (this.getItemLabelGenerator() != null) {
            vaadinItem.setText(this.getItemLabelGenerator().apply(item));
        } else {
            vaadinItem.setText(item.toString());
        }
        if (this.getItemLabelGenerator() != null) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, this.getItemLabelGenerator().apply(item));
        } else if (item == this.emptySelectionItem) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, "");
        } else {
            vaadinItem.getElement().removeAttribute(LABEL_ATTRIBUTE);
        }
        this.updateItemEnabled(vaadinItem);
        this.callClientSideRenderIfNotPending();
    }

    private void updateItemEnabled(VaadinItem<T> item) {
        boolean itemEnabled = this.isItemEnabled(item.getItem());
        boolean disabled = this.isDisabledBoolean() || !itemEnabled;
        item.getElement().setEnabled(!disabled);
        item.getElement().setAttribute("disabled", !itemEnabled);
    }

    private void refreshItems() {
        this.getItems().forEach(this::updateItem);
    }

    private Stream<VaadinItem<T>> getItems() {
        return this.listBox.getChildren().filter(component -> component instanceof VaadinItem).map(child -> (VaadinItem)((Object)child));
    }

    private void reset() {
        this.keyMapper.removeAll();
        this.listBox.removeAll();
        this.clear();
        this.callClientSideRenderIfNotPending();
        if (this.isEmptySelectionAllowed()) {
            this.addEmptySelectionItem();
        }
        this.getDataProvider().fetch(new Query()).map(this::createItem).forEach(xva$0 -> this.add((Component)xva$0));
    }

    private void callClientSideRenderIfNotPending() {
        if (!this.resetPending) {
            this.resetPending = true;
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
                ui.getPage().executeJavaScript("$0.render();", new Serializable[]{this.getElement()});
                this.resetPending = false;
            });
        }
    }

    private void onDataChange(DataChangeEvent<T> event) {
        if (event instanceof DataChangeEvent.DataRefreshEvent) {
            Object updatedItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
            Object updatedItemId = this.getDataProvider().getId(updatedItem);
            this.getItems().filter(vaadinItem -> updatedItemId.equals(this.getDataProvider().getId(vaadinItem.getItem()))).findAny().ifPresent(this::updateItem);
        } else {
            this.reset();
        }
    }

    private T getValue(Serializable key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        return (T)this.keyMapper.get(key.toString());
    }

    private void addEmptySelectionItem() {
        if (this.emptySelectionItem == null) {
            this.emptySelectionItem = new VaadinItem<Object>("", null);
        }
        this.updateItem(this.emptySelectionItem);
        this.addComponentAsFirst(this.emptySelectionItem);
        if (this.getValue() == null) {
            this.setValue(null);
        }
    }

    private void removeEmptySelectionItem() {
        if (this.emptySelectionItem != null) {
            this.listBox.remove(new Component[]{this.emptySelectionItem});
        }
        this.emptySelectionItem = null;
    }

    private void validateSelectionEnabledState(PropertyChangeEvent event) {
        if (!event.isUserOriginated()) {
            return;
        }
        if (!this.hasValidValue() || this.isReadOnly()) {
            T oldValue = this.getValue(event.getOldValue());
            try {
                this.validationRegistration.remove();
                this.getElement().setProperty("value", this.keyMapper.key(oldValue));
            }
            finally {
                this.registerValidation();
            }
            Optional<VaadinItem> selectedItem = this.getItems().filter(item -> item.getItem() == this.getValue(event.getValue())).findFirst();
            selectedItem.ifPresent(this::updateItemEnabled);
        }
    }

    private void registerValidation() {
        if (this.validationRegistration != null) {
            this.validationRegistration.remove();
        }
        this.validationRegistration = this.getElement().addPropertyChangeListener("value", this.validationListener);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    @Tag(value="vaadin-list-box")
    private class InternalListBox<T>
    extends Component
    implements HasItemsAndComponents<T> {
        private InternalListBox() {
        }

        public void setItems(Collection<T> collection) {
            throw new UnsupportedOperationException("The setItems method of the internal ListBox of the Select component should never be called.");
        }

        public int getItemPosition(T item) {
            if (item == null && Select.this.isEmptySelectionAllowed()) {
                return 0;
            }
            return super.getItemPosition(item);
        }
    }
}

