/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import java.util.Arrays;

public interface FlexComponent<C extends Component>
extends HasOrderedComponents<C>,
HasStyle,
HasSize {
    default public void setAlignItems(Alignment alignment) {
        if (alignment == null) {
            this.getStyle().remove("alignItems");
        } else {
            this.getStyle().set("alignItems", alignment.getFlexValue());
        }
    }

    default public Alignment getAlignItems() {
        return Alignment.toAlignment(this.getStyle().get("alignItems"), Alignment.STRETCH);
    }

    default public void setAlignSelf(Alignment alignment, HasElement ... elementContainers) {
        if (alignment == null) {
            for (HasElement container : elementContainers) {
                container.getElement().getStyle().remove("alignSelf");
            }
        } else {
            for (HasElement container : elementContainers) {
                container.getElement().getStyle().set("alignSelf", alignment.getFlexValue());
            }
        }
    }

    default public Alignment getAlignSelf(HasElement container) {
        return Alignment.toAlignment(container.getElement().getStyle().get("alignSelf"), Alignment.AUTO);
    }

    default public void setFlexGrow(double flexGrow, HasElement ... elementContainers) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property cannot be negative");
        }
        if (flexGrow == 0.0) {
            for (HasElement container : elementContainers) {
                container.getElement().getStyle().remove("flexGrow");
            }
        } else {
            for (HasElement container : elementContainers) {
                container.getElement().getStyle().set("flexGrow", String.valueOf(flexGrow));
            }
        }
    }

    default public double getFlexGrow(HasElement elementContainer) {
        String ratio = elementContainer.getElement().getStyle().get("flexGrow");
        if (ratio == null || ratio.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(ratio);
        }
        catch (Exception e) {
            throw new IllegalStateException("The flex grow property of the element container is not parseable to double: " + ratio, e);
        }
    }

    default public void setJustifyContentMode(JustifyContentMode justifyContentMode) {
        if (justifyContentMode == null) {
            throw new IllegalArgumentException("The 'justifyContentMode' argument can not be null");
        }
        this.getElement().getStyle().set("justifyContent", justifyContentMode.getFlexValue());
    }

    default public JustifyContentMode getJustifyContentMode() {
        return JustifyContentMode.toJustifyContentMode(this.getElement().getStyle().get("justifyContent"), JustifyContentMode.START);
    }

    default public void expand(Component ... componentsToExpand) {
        this.setFlexGrow(1.0, (HasElement[])componentsToExpand);
    }

    default public void replace(Component oldComponent, Component newComponent) {
        Alignment alignSelf = null;
        double flexGrow = 0.0;
        if (oldComponent != null) {
            alignSelf = this.getAlignSelf((HasElement)oldComponent);
            flexGrow = this.getFlexGrow((HasElement)oldComponent);
        }
        super.replace(oldComponent, newComponent);
        if (newComponent != null && oldComponent != null) {
            this.setAlignSelf(alignSelf, new HasElement[]{newComponent});
            this.setFlexGrow(flexGrow, new HasElement[]{newComponent});
        }
    }

    public static enum JustifyContentMode {
        START("flex-start"),
        END("flex-end"),
        CENTER("center"),
        BETWEEN("space-between"),
        AROUND("space-around"),
        EVENLY("space-evenly");

        private final String flexValue;

        private JustifyContentMode(String flexValue) {
            this.flexValue = flexValue;
        }

        String getFlexValue() {
            return this.flexValue;
        }

        static JustifyContentMode toJustifyContentMode(String flexValue, JustifyContentMode defaultValue) {
            return Arrays.stream(JustifyContentMode.values()).filter(justifyContent -> justifyContent.getFlexValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }

    public static enum Alignment {
        START("flex-start"),
        END("flex-end"),
        CENTER("center"),
        STRETCH("stretch"),
        BASELINE("baseline"),
        AUTO("auto");

        private final String flexValue;

        private Alignment(String flexValue) {
            this.flexValue = flexValue;
        }

        String getFlexValue() {
            return this.flexValue;
        }

        static Alignment toAlignment(String flexValue, Alignment defaultValue) {
            return Arrays.stream(Alignment.values()).filter(alignment -> alignment.getFlexValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }
}

