/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.sort.SortOrder;
import com.vaadin.v7.data.util.AbstractContainer;
import com.vaadin.v7.data.util.PropertyValueGenerator;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class GeneratedPropertyContainer
extends AbstractContainer
implements Container.Indexed,
Container.Sortable,
Container.Filterable,
Container.PropertySetChangeNotifier,
Container.ItemSetChangeNotifier {
    private final Container.Indexed wrappedContainer;
    private final Map<Object, PropertyValueGenerator<?>> propertyGenerators;
    private final Map<Container.Filter, List<Container.Filter>> activeFilters;
    private Container.Sortable sortableContainer = null;
    private Container.Filterable filterableContainer = null;
    private final Set<Object> removedProperties = new HashSet<Object>();

    @Deprecated
    public GeneratedPropertyContainer(Container.Indexed container) {
        this.wrappedContainer = container;
        this.propertyGenerators = new HashMap();
        if (this.wrappedContainer instanceof Container.Sortable) {
            this.sortableContainer = (Container.Sortable)((Object)this.wrappedContainer);
        }
        if (this.wrappedContainer instanceof Container.Filterable) {
            this.activeFilters = new HashMap<Container.Filter, List<Container.Filter>>();
            this.filterableContainer = (Container.Filterable)((Object)this.wrappedContainer);
        } else {
            this.activeFilters = null;
        }
        if (this.wrappedContainer instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.wrappedContainer)).addItemSetChangeListener(new Container.ItemSetChangeListener(){

                @Override
                public void containerItemSetChange(Container.ItemSetChangeEvent event) {
                    if (event instanceof Container.Indexed.ItemAddEvent) {
                        Container.Indexed.ItemAddEvent addEvent = (Container.Indexed.ItemAddEvent)event;
                        GeneratedPropertyContainer.this.fireItemSetChange(new GeneratedItemAddEvent(addEvent));
                    } else if (event instanceof Container.Indexed.ItemRemoveEvent) {
                        Container.Indexed.ItemRemoveEvent removeEvent = (Container.Indexed.ItemRemoveEvent)event;
                        GeneratedPropertyContainer.this.fireItemSetChange(new GeneratedItemRemoveEvent(removeEvent));
                    } else {
                        GeneratedPropertyContainer.this.fireItemSetChange();
                    }
                }
            });
        }
        if (this.wrappedContainer instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.wrappedContainer)).addPropertySetChangeListener(new Container.PropertySetChangeListener(){

                @Override
                public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
                    GeneratedPropertyContainer.this.fireContainerPropertySetChange();
                }
            });
        }
    }

    public void addGeneratedProperty(Object propertyId, PropertyValueGenerator<?> generator) {
        this.propertyGenerators.put(propertyId, generator);
        this.fireContainerPropertySetChange();
    }

    public void removeGeneratedProperty(Object propertyId) {
        if (this.propertyGenerators.containsKey(propertyId)) {
            this.propertyGenerators.remove(propertyId);
            this.fireContainerPropertySetChange();
        }
    }

    private Item createGeneratedPropertyItem(Object itemId, Item item) {
        return new GeneratedPropertyItem(itemId, item);
    }

    private <T> Property<T> createProperty(Item item, Object propertyId, Object itemId, PropertyValueGenerator<T> generator) {
        return new GeneratedProperty<T>(item, propertyId, itemId, generator);
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.addItemSetChangeListener(listener);
    }

    @Override
    public void addListener(Container.ItemSetChangeListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.removeItemSetChangeListener(listener);
    }

    @Override
    public void removeListener(Container.ItemSetChangeListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.addPropertySetChangeListener(listener);
    }

    @Override
    public void addListener(Container.PropertySetChangeListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.removePropertySetChangeListener(listener);
    }

    @Override
    public void removeListener(Container.PropertySetChangeListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        if (this.filterableContainer == null) {
            throw new UnsupportedOperationException("Wrapped container is not filterable");
        }
        ArrayList<Container.Filter> addedFilters = new ArrayList<Container.Filter>();
        for (Map.Entry<Object, PropertyValueGenerator<?>> entry : this.propertyGenerators.entrySet()) {
            Object property = entry.getKey();
            if (!filter.appliesToProperty(property)) continue;
            Container.Filter modifiedFilter = entry.getValue().modifyFilter(filter);
            this.filterableContainer.addContainerFilter(modifiedFilter);
            addedFilters.add(modifiedFilter);
        }
        if (addedFilters.isEmpty()) {
            addedFilters.add(filter);
            this.filterableContainer.addContainerFilter(filter);
        }
        this.activeFilters.put(filter, addedFilters);
    }

    @Override
    public void removeContainerFilter(Container.Filter filter) {
        if (this.filterableContainer == null) {
            throw new UnsupportedOperationException("Wrapped container is not filterable");
        }
        if (this.activeFilters.containsKey(filter)) {
            for (Container.Filter f : this.activeFilters.get(filter)) {
                this.filterableContainer.removeContainerFilter(f);
            }
            this.activeFilters.remove(filter);
        }
    }

    @Override
    public void removeAllContainerFilters() {
        if (this.filterableContainer == null) {
            throw new UnsupportedOperationException("Wrapped container is not filterable");
        }
        this.filterableContainer.removeAllContainerFilters();
        this.activeFilters.clear();
    }

    @Override
    public Collection<Container.Filter> getContainerFilters() {
        if (this.filterableContainer == null) {
            throw new UnsupportedOperationException("Wrapped container is not filterable");
        }
        return Collections.unmodifiableSet(this.activeFilters.keySet());
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) {
        if (this.sortableContainer == null) {
            throw new UnsupportedOperationException("Wrapped container is not Sortable");
        }
        if (propertyId.length == 0) {
            this.sortableContainer.sort(propertyId, ascending);
            return;
        }
        ArrayList<Object> actualSortProperties = new ArrayList<Object>();
        ArrayList<Boolean> actualSortDirections = new ArrayList<Boolean>();
        for (int i = 0; i < propertyId.length; ++i) {
            Object property = propertyId[i];
            boolean isAscending = i < ascending.length ? ascending[i] : true;
            SortDirection direction = isAscending ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            if (this.propertyGenerators.containsKey(property)) {
                for (SortOrder s : this.propertyGenerators.get(property).getSortProperties(new SortOrder(property, direction))) {
                    actualSortProperties.add(s.getPropertyId());
                    actualSortDirections.add(s.getDirection() == SortDirection.ASCENDING);
                }
                continue;
            }
            actualSortProperties.add(property);
            actualSortDirections.add(isAscending);
        }
        boolean[] actualAscending = new boolean[actualSortDirections.size()];
        for (int i = 0; i < actualAscending.length; ++i) {
            actualAscending[i] = (Boolean)actualSortDirections.get(i);
        }
        this.sortableContainer.sort(actualSortProperties.toArray(), actualAscending);
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        if (this.sortableContainer == null) {
            return Collections.emptySet();
        }
        HashSet sortablePropertySet = new HashSet(this.sortableContainer.getSortableContainerPropertyIds());
        for (Map.Entry<Object, PropertyValueGenerator<?>> entry : this.propertyGenerators.entrySet()) {
            Object property = entry.getKey();
            SortOrder order = new SortOrder(property, SortDirection.ASCENDING);
            if (entry.getValue().getSortProperties(order).length > 0) {
                sortablePropertySet.add(property);
                continue;
            }
            sortablePropertySet.remove(property);
        }
        return sortablePropertySet;
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        Item item = this.wrappedContainer.addItemAfter(previousItemId, newItemId);
        if (item == null) {
            return null;
        }
        return this.createGeneratedPropertyItem(newItemId, item);
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        Item item = this.wrappedContainer.addItem(itemId);
        if (item == null) {
            return null;
        }
        return this.createGeneratedPropertyItem(itemId, item);
    }

    @Override
    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        Item item = this.wrappedContainer.addItemAt(index, newItemId);
        if (item == null) {
            return null;
        }
        return this.createGeneratedPropertyItem(newItemId, item);
    }

    @Override
    public Item getItem(Object itemId) {
        Item item = this.wrappedContainer.getItem(itemId);
        if (item == null) {
            return null;
        }
        return this.createGeneratedPropertyItem(itemId, item);
    }

    @Override
    public Property<?> getContainerProperty(Object itemId, Object propertyId) {
        if (this.propertyGenerators.keySet().contains(propertyId)) {
            return this.getItem(itemId).getItemProperty(propertyId);
        }
        if (!this.removedProperties.contains(propertyId)) {
            return this.wrappedContainer.getContainerProperty(itemId, propertyId);
        }
        return null;
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        LinkedHashSet<Object> wrappedProperties = new LinkedHashSet<Object>(this.wrappedContainer.getContainerPropertyIds());
        wrappedProperties.removeAll(this.removedProperties);
        wrappedProperties.addAll(this.propertyGenerators.keySet());
        return wrappedProperties;
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        if (!this.removedProperties.contains(propertyId)) {
            throw new UnsupportedOperationException("GeneratedPropertyContainer does not support adding properties.");
        }
        this.removedProperties.remove(propertyId);
        this.fireContainerPropertySetChange();
        return true;
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        if (this.wrappedContainer.getContainerPropertyIds().contains(propertyId) && this.removedProperties.add(propertyId)) {
            this.fireContainerPropertySetChange();
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getType(Object propertyId) {
        if (this.propertyGenerators.containsKey(propertyId)) {
            return this.propertyGenerators.get(propertyId).getType();
        }
        return this.wrappedContainer.getType(propertyId);
    }

    @Override
    public Object nextItemId(Object itemId) {
        return this.wrappedContainer.nextItemId(itemId);
    }

    @Override
    public Object prevItemId(Object itemId) {
        return this.wrappedContainer.prevItemId(itemId);
    }

    @Override
    public Object firstItemId() {
        return this.wrappedContainer.firstItemId();
    }

    @Override
    public Object lastItemId() {
        return this.wrappedContainer.lastItemId();
    }

    @Override
    public boolean isFirstId(Object itemId) {
        return this.wrappedContainer.isFirstId(itemId);
    }

    @Override
    public boolean isLastId(Object itemId) {
        return this.wrappedContainer.isLastId(itemId);
    }

    @Override
    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        return this.wrappedContainer.addItemAfter(previousItemId);
    }

    @Override
    public Collection<?> getItemIds() {
        return this.wrappedContainer.getItemIds();
    }

    @Override
    public int size() {
        return this.wrappedContainer.size();
    }

    @Override
    public boolean containsId(Object itemId) {
        return this.wrappedContainer.containsId(itemId);
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        return this.wrappedContainer.addItem();
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        return this.wrappedContainer.removeItem(itemId);
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        return this.wrappedContainer.removeAllItems();
    }

    @Override
    public int indexOfId(Object itemId) {
        return this.wrappedContainer.indexOfId(itemId);
    }

    @Override
    public Object getIdByIndex(int index) {
        return this.wrappedContainer.getIdByIndex(index);
    }

    @Override
    public List<?> getItemIds(int startIndex, int numberOfItems) {
        return this.wrappedContainer.getItemIds(startIndex, numberOfItems);
    }

    @Override
    public Object addItemAt(int index) throws UnsupportedOperationException {
        return this.wrappedContainer.addItemAt(index);
    }

    public Container.Indexed getWrappedContainer() {
        return this.wrappedContainer;
    }

    @Deprecated
    protected class GeneratedItemAddEvent
    extends GeneratedItemAddOrRemoveEvent
    implements Container.Indexed.ItemAddEvent {
        protected GeneratedItemAddEvent(Container.Indexed.ItemAddEvent event) {
            super(event.getFirstItemId(), event.getFirstIndex(), event.getAddedItemsCount());
        }

        @Override
        public int getAddedItemsCount() {
            return super.getAffectedItemsCount();
        }
    }

    @Deprecated
    protected class GeneratedItemRemoveEvent
    extends GeneratedItemAddOrRemoveEvent
    implements Container.Indexed.ItemRemoveEvent {
        protected GeneratedItemRemoveEvent(Container.Indexed.ItemRemoveEvent event) {
            super(event.getFirstItemId(), event.getFirstIndex(), event.getRemovedItemsCount());
        }

        @Override
        public int getRemovedItemsCount() {
            return super.getAffectedItemsCount();
        }
    }

    @Deprecated
    protected abstract class GeneratedItemAddOrRemoveEvent
    implements Serializable {
        private Object firstItemId;
        private int firstIndex;
        private int count;

        protected GeneratedItemAddOrRemoveEvent(Object itemId, int first, int count) {
            this.firstItemId = itemId;
            this.firstIndex = first;
            this.count = count;
        }

        public Container getContainer() {
            return GeneratedPropertyContainer.this;
        }

        public Object getFirstItemId() {
            return this.firstItemId;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }

        public int getAffectedItemsCount() {
            return this.count;
        }
    }

    @Deprecated
    public class GeneratedPropertyItem
    implements Item {
        private Item wrappedItem;
        private Object itemId;

        protected GeneratedPropertyItem(Object itemId, Item item) {
            this.itemId = itemId;
            this.wrappedItem = item;
        }

        @Override
        public Property getItemProperty(Object id) {
            if (GeneratedPropertyContainer.this.propertyGenerators.containsKey(id)) {
                return GeneratedPropertyContainer.this.createProperty(this.wrappedItem, id, this.itemId, (PropertyValueGenerator)GeneratedPropertyContainer.this.propertyGenerators.get(id));
            }
            return this.wrappedItem.getItemProperty(id);
        }

        @Override
        public Collection<?> getItemPropertyIds() {
            LinkedHashSet wrappedProperties = new LinkedHashSet(this.wrappedItem.getItemPropertyIds());
            wrappedProperties.removeAll(GeneratedPropertyContainer.this.removedProperties);
            wrappedProperties.addAll(GeneratedPropertyContainer.this.propertyGenerators.keySet());
            return wrappedProperties;
        }

        @Override
        public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("GeneratedPropertyItem does not support adding properties");
        }

        @Override
        public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("GeneratedPropertyItem does not support removing properties");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(GeneratedPropertyItem.class)) {
                return false;
            }
            GeneratedPropertyItem li = (GeneratedPropertyItem)obj;
            return this.getContainer() == li.getContainer() && this.itemId.equals(li.itemId);
        }

        public int hashCode() {
            return this.itemId.hashCode();
        }

        private GeneratedPropertyContainer getContainer() {
            return GeneratedPropertyContainer.this;
        }

        public Item getWrappedItem() {
            return this.wrappedItem;
        }
    }

    @Deprecated
    protected static class GeneratedProperty<T>
    implements Property<T> {
        private Item item;
        private Object itemId;
        private Object propertyId;
        private PropertyValueGenerator<T> generator;

        public GeneratedProperty(Item item, Object propertyId, Object itemId, PropertyValueGenerator<T> generator) {
            this.item = item;
            this.itemId = itemId;
            this.propertyId = propertyId;
            this.generator = generator;
        }

        @Override
        public T getValue() {
            return this.generator.getValue(this.item, this.itemId, this.propertyId);
        }

        @Override
        public void setValue(T newValue) throws Property.ReadOnlyException {
            throw new Property.ReadOnlyException("Generated properties are read only");
        }

        @Override
        public Class<? extends T> getType() {
            return this.generator.getType();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setReadOnly(boolean newStatus) {
            if (newStatus) {
                return;
            }
            throw new UnsupportedOperationException("Generated properties are read only");
        }
    }
}

