/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractContainer;
import com.vaadin.v7.data.util.HierarchicalContainer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;

@Deprecated
public class ContainerHierarchicalWrapper
implements Container.Hierarchical,
Container.ItemSetChangeNotifier,
Container.PropertySetChangeNotifier {
    private final Container container;
    private HashSet<Object> noChildrenAllowed = null;
    private Map<Object, Object> parent = null;
    private Map<Object, LinkedList<Object>> children = null;
    private LinkedHashSet<Object> roots = null;
    private boolean hierarchical;

    public ContainerHierarchicalWrapper(Container toBeWrapped) {
        this.container = toBeWrapped;
        this.hierarchical = this.container instanceof Container.Hierarchical;
        if (this.container == null) {
            throw new NullPointerException("Null can not be wrapped");
        }
        if (!this.hierarchical) {
            this.noChildrenAllowed = new HashSet();
            this.parent = new Hashtable<Object, Object>();
            this.children = new Hashtable<Object, LinkedList<Object>>();
            this.roots = new LinkedHashSet(this.container.getItemIds());
        }
        this.updateHierarchicalWrapper();
    }

    public void updateHierarchicalWrapper() {
        if (!this.hierarchical) {
            if (this.noChildrenAllowed == null || this.parent == null || this.children == null || this.roots == null) {
                this.noChildrenAllowed = new HashSet();
                this.parent = new Hashtable<Object, Object>();
                this.children = new Hashtable<Object, LinkedList<Object>>();
                this.roots = new LinkedHashSet(this.container.getItemIds());
            } else {
                Collection<?> itemIds = this.container.getItemIds();
                ListedItemsFirstComparator basedOnOrderFromWrappedContainer = new ListedItemsFirstComparator(itemIds);
                HashSet<Object> s = new HashSet<Object>();
                s.addAll(this.parent.keySet());
                s.addAll(this.children.keySet());
                s.addAll(this.roots);
                for (Object e : s) {
                    if (this.container.containsId(e)) continue;
                    this.removeFromHierarchyWrapper(e);
                }
                Collection<?> ids = this.container.getItemIds();
                for (Object id : ids) {
                    if (s.contains(id)) continue;
                    this.addToHierarchyWrapper(id);
                    s.add(id);
                }
                Object[] objectArray = this.roots.toArray();
                Arrays.sort(objectArray, basedOnOrderFromWrappedContainer);
                this.roots = new LinkedHashSet();
                for (Object root : objectArray) {
                    this.roots.add(root);
                }
                for (Object e : this.children.keySet()) {
                    LinkedList<Object> object2 = this.children.get(e);
                    Collections.sort(object2, basedOnOrderFromWrappedContainer);
                }
            }
        }
    }

    private void removeFromHierarchyWrapper(Object itemId) {
        LinkedList<Object> linkedList;
        LinkedList<Object> oprhanedChildren = this.children.remove(itemId);
        if (oprhanedChildren != null) {
            for (Object e : oprhanedChildren) {
                this.setParent(e, null);
            }
        }
        this.roots.remove(itemId);
        Object p = this.parent.get(itemId);
        if (p != null && (linkedList = this.children.get(p)) != null) {
            linkedList.remove(itemId);
        }
        this.parent.remove(itemId);
        this.noChildrenAllowed.remove(itemId);
    }

    private void addToHierarchyWrapper(Object itemId) {
        this.roots.add(itemId);
    }

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).areChildrenAllowed(itemId);
        }
        if (this.noChildrenAllowed.contains(itemId)) {
            return false;
        }
        return this.containsId(itemId);
    }

    @Override
    public Collection<?> getChildren(Object itemId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).getChildren(itemId);
        }
        Collection c = this.children.get(itemId);
        if (c == null) {
            return null;
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    public Object getParent(Object itemId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).getParent(itemId);
        }
        return this.parent.get(itemId);
    }

    @Override
    public boolean hasChildren(Object itemId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).hasChildren(itemId);
        }
        LinkedList<Object> list = this.children.get(itemId);
        return list != null && !list.isEmpty();
    }

    @Override
    public boolean isRoot(Object itemId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).isRoot(itemId);
        }
        if (this.parent.containsKey(itemId)) {
            return false;
        }
        return this.containsId(itemId);
    }

    @Override
    public Collection<?> rootItemIds() {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).rootItemIds();
        }
        return Collections.unmodifiableCollection(this.roots);
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean childrenAllowed) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).setChildrenAllowed(itemId, childrenAllowed);
        }
        if (!this.containsId(itemId)) {
            return false;
        }
        if (childrenAllowed) {
            this.noChildrenAllowed.remove(itemId);
        } else {
            this.noChildrenAllowed.add(itemId);
        }
        return true;
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId) {
        if (this.hierarchical) {
            return ((Container.Hierarchical)this.container).setParent(itemId, newParentId);
        }
        if (!this.containsId(itemId)) {
            return false;
        }
        Object oldParentId = this.parent.get(itemId);
        if (newParentId == null && oldParentId == null || newParentId != null && newParentId.equals(oldParentId)) {
            return true;
        }
        if (newParentId == null) {
            LinkedList<Object> l = this.children.get(oldParentId);
            if (l != null) {
                l.remove(itemId);
                if (l.isEmpty()) {
                    this.children.remove(itemId);
                }
            }
            this.roots.add(itemId);
            this.parent.remove(itemId);
            this.fireItemSetChangeIfAbstractContainer();
            return true;
        }
        if (!this.containsId(newParentId) || this.noChildrenAllowed.contains(newParentId)) {
            return false;
        }
        Object o = newParentId;
        while (o != null && !o.equals(itemId)) {
            o = this.parent.get(o);
        }
        if (o != null) {
            return false;
        }
        this.parent.put(itemId, newParentId);
        LinkedList<Object> pcl = this.children.get(newParentId);
        if (pcl == null) {
            pcl = new LinkedList();
            this.children.put(newParentId, pcl);
        }
        pcl.add(itemId);
        if (oldParentId == null) {
            this.roots.remove(itemId);
        } else {
            LinkedList<Object> l = this.children.get(oldParentId);
            if (l != null) {
                l.remove(itemId);
                if (l.isEmpty()) {
                    this.children.remove(oldParentId);
                }
            }
        }
        this.fireItemSetChangeIfAbstractContainer();
        return true;
    }

    private void fireItemSetChangeIfAbstractContainer() {
        if (this.container instanceof AbstractContainer) {
            ((AbstractContainer)this.container).fireItemSetChange();
        }
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object id = this.container.addItem();
        if (!this.hierarchical && id != null) {
            this.addToHierarchyWrapper(id);
        }
        return id;
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        if (itemId == null) {
            return null;
        }
        Item item = this.container.addItem(itemId);
        if (!this.hierarchical && item != null) {
            this.addToHierarchyWrapper(itemId);
        }
        return item;
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        boolean success = this.container.removeAllItems();
        if (!this.hierarchical && success) {
            this.roots.clear();
            this.parent.clear();
            this.children.clear();
            this.noChildrenAllowed.clear();
        }
        return success;
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        boolean success = this.container.removeItem(itemId);
        if (!this.hierarchical && success) {
            this.removeFromHierarchyWrapper(itemId);
        }
        return success;
    }

    public boolean removeItemRecursively(Object itemId) {
        return HierarchicalContainer.removeItemRecursively(this, itemId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        return this.container.addContainerProperty(propertyId, type, defaultValue);
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        return this.container.removeContainerProperty(propertyId);
    }

    @Override
    public boolean containsId(Object itemId) {
        return this.container.containsId(itemId);
    }

    @Override
    public Item getItem(Object itemId) {
        return this.container.getItem(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        return this.container.getItemIds();
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.container.getContainerProperty(itemId, propertyId);
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return this.container.getContainerPropertyIds();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.container.getType(propertyId);
    }

    @Override
    public int size() {
        int size = this.container.size();
        assert (size >= 0);
        return size;
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).addItemSetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).removeItemSetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.container instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.container)).addPropertySetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.container instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.container)).removePropertySetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    private class PiggybackListener
    implements Container.PropertySetChangeListener,
    Container.ItemSetChangeListener {
        Object listener;

        public PiggybackListener(Object realListener) {
            this.listener = realListener;
        }

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            ContainerHierarchicalWrapper.this.updateHierarchicalWrapper();
            ((Container.ItemSetChangeListener)this.listener).containerItemSetChange(event);
        }

        @Override
        public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
            ContainerHierarchicalWrapper.this.updateHierarchicalWrapper();
            ((Container.PropertySetChangeListener)this.listener).containerPropertySetChange(event);
        }

        public boolean equals(Object obj) {
            return obj == this.listener || obj != null && obj.equals(this.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    private static class ListedItemsFirstComparator
    implements Comparator<Object>,
    Serializable {
        private final Collection<?> itemIds;

        private ListedItemsFirstComparator(Collection<?> itemIds) {
            this.itemIds = itemIds;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            for (Object id : this.itemIds) {
                if (id == o1) {
                    return -1;
                }
                if (id != o2) continue;
                return 1;
            }
            return 0;
        }
    }
}

