/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractInMemoryContainer;
import com.vaadin.v7.data.util.BeanItem;
import com.vaadin.v7.data.util.ItemSorter;
import com.vaadin.v7.data.util.MethodProperty;
import com.vaadin.v7.data.util.NestedPropertyDescriptor;
import com.vaadin.v7.data.util.PropertysetItem;
import com.vaadin.v7.data.util.VaadinPropertyDescriptor;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public abstract class AbstractBeanContainer<IDTYPE, BEANTYPE>
extends AbstractInMemoryContainer<IDTYPE, String, BeanItem<BEANTYPE>>
implements Container.Filterable,
Container.SimpleFilterable,
Container.Sortable,
Property.ValueChangeListener,
Container.PropertySetChangeNotifier {
    private BeanIdResolver<IDTYPE, BEANTYPE> beanIdResolver = null;
    private final Map<IDTYPE, BeanItem<BEANTYPE>> itemIdToItem = new HashMap<IDTYPE, BeanItem<BEANTYPE>>();
    private final Class<? super BEANTYPE> type;
    private final LinkedHashMap<String, VaadinPropertyDescriptor<BEANTYPE>> model;

    protected AbstractBeanContainer(Class<? super BEANTYPE> type) {
        if (type == null) {
            throw new IllegalArgumentException("The bean type passed to AbstractBeanContainer must not be null");
        }
        this.type = type;
        this.model = BeanItem.getPropertyDescriptors(type);
    }

    @Override
    public Class<?> getType(Object propertyId) {
        VaadinPropertyDescriptor<BEANTYPE> descriptor = this.model.get(propertyId);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getPropertyType();
    }

    protected BeanItem<BEANTYPE> createBeanItem(BEANTYPE bean) {
        return bean == null ? null : new BeanItem<BEANTYPE>(bean, this.model);
    }

    public Class<? super BEANTYPE> getBeanType() {
        return this.type;
    }

    public Collection<String> getContainerPropertyIds() {
        return this.model.keySet();
    }

    @Override
    public boolean removeAllItems() {
        int origSize = this.size();
        Object firstItem = this.getFirstVisibleItem();
        this.internalRemoveAllItems();
        for (Item item : this.itemIdToItem.values()) {
            this.removeAllValueChangeListeners(item);
        }
        this.itemIdToItem.clear();
        if (origSize != 0) {
            this.fireItemsRemoved(0, firstItem, origSize);
        }
        return true;
    }

    @Override
    public BeanItem<BEANTYPE> getItem(Object itemId) {
        return this.getUnfilteredItem(itemId);
    }

    @Override
    protected BeanItem<BEANTYPE> getUnfilteredItem(Object itemId) {
        return this.itemIdToItem.get(itemId);
    }

    @Override
    public List<IDTYPE> getItemIds() {
        return super.getItemIds();
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        if (item == null) {
            return null;
        }
        return item.getItemProperty(propertyId);
    }

    @Override
    public boolean removeItem(Object itemId) {
        int origSize = this.size();
        Item item = this.getItem(itemId);
        int position = this.indexOfId(itemId);
        if (this.internalRemoveItem(itemId)) {
            this.removeAllValueChangeListeners(item);
            this.itemIdToItem.remove(itemId);
            if (this.size() != origSize) {
                this.fireItemRemoved(position, itemId);
            }
            return true;
        }
        return false;
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        this.filterAll();
    }

    @Override
    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        try {
            this.addFilter(new SimpleStringFilter(propertyId, filterString, ignoreCase, onlyMatchPrefix));
        }
        catch (UnsupportedFilterException unsupportedFilterException) {
            // empty catch block
        }
    }

    @Override
    public void removeAllContainerFilters() {
        if (!this.getFilters().isEmpty()) {
            for (Item item : this.itemIdToItem.values()) {
                this.removeAllValueChangeListeners(item);
            }
            this.removeAllFilters();
        }
    }

    @Override
    public void removeContainerFilters(Object propertyId) {
        Collection<Container.Filter> removedFilters = super.removeFilters(propertyId);
        if (!removedFilters.isEmpty()) {
            for (Item item : this.itemIdToItem.values()) {
                this.removeValueChangeListener(item, propertyId);
            }
        }
    }

    @Override
    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.addFilter(filter);
    }

    @Override
    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(filter);
    }

    @Override
    public boolean hasContainerFilters() {
        return super.hasContainerFilters();
    }

    @Override
    public Collection<Container.Filter> getContainerFilters() {
        return super.getContainerFilters();
    }

    private void addValueChangeListener(Item item, Object propertyId) {
        Property property = item.getItemProperty(propertyId);
        if (property instanceof Property.ValueChangeNotifier) {
            Property.ValueChangeNotifier notifier = (Property.ValueChangeNotifier)((Object)property);
            notifier.removeListener(this);
            notifier.addListener(this);
        }
    }

    private void removeValueChangeListener(Item item, Object propertyId) {
        Property property = item.getItemProperty(propertyId);
        if (property instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)((Object)property)).removeListener(this);
        }
    }

    private void removeAllValueChangeListeners(Item item) {
        for (Object propertyId : item.getItemPropertyIds()) {
            this.removeValueChangeListener(item, propertyId);
        }
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        return this.getSortablePropertyIds();
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) {
        this.sortContainer(propertyId, ascending);
    }

    @Override
    public ItemSorter getItemSorter() {
        return super.getItemSorter();
    }

    @Override
    public void setItemSorter(ItemSorter itemSorter) {
        super.setItemSorter(itemSorter);
    }

    @Override
    protected void registerNewItem(int position, IDTYPE itemId, BeanItem<BEANTYPE> item) {
        this.itemIdToItem.put(itemId, item);
        for (Container.Filter filter : this.getFilters()) {
            for (String propertyId : this.getContainerPropertyIds()) {
                if (!filter.appliesToProperty(propertyId)) continue;
                this.addValueChangeListener(item, propertyId);
            }
        }
    }

    private boolean validateBean(BEANTYPE bean) {
        return bean != null && this.getBeanType().isAssignableFrom(bean.getClass());
    }

    protected BeanItem<BEANTYPE> addItem(IDTYPE itemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return this.internalAddItemAtEnd(itemId, this.createBeanItem(bean), true);
    }

    protected BeanItem<BEANTYPE> addItemAfter(IDTYPE previousItemId, IDTYPE newItemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return this.internalAddItemAfter(previousItemId, newItemId, this.createBeanItem(bean), true);
    }

    protected BeanItem<BEANTYPE> addItemAt(int index, IDTYPE newItemId, BEANTYPE bean) {
        if (!this.validateBean(bean)) {
            return null;
        }
        return this.internalAddItemAt(index, newItemId, this.createBeanItem(bean), true);
    }

    protected BeanItem<BEANTYPE> addBean(BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItem(itemId, bean);
    }

    protected BeanItem<BEANTYPE> addBeanAfter(IDTYPE previousItemId, BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItemAfter(previousItemId, itemId, bean);
    }

    protected BeanItem<BEANTYPE> addBeanAt(int index, BEANTYPE bean) throws IllegalStateException, IllegalArgumentException {
        if (bean == null) {
            return null;
        }
        IDTYPE itemId = this.resolveBeanId(bean);
        if (itemId == null) {
            throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
        }
        return this.addItemAt(index, itemId, bean);
    }

    protected void addAll(Collection<? extends BEANTYPE> collection) throws IllegalStateException, IllegalArgumentException {
        boolean modified = false;
        int origSize = this.size();
        for (BEANTYPE bean : collection) {
            if (bean == null || !this.getBeanType().isAssignableFrom(bean.getClass())) continue;
            IDTYPE itemId = this.resolveBeanId(bean);
            if (itemId == null) {
                throw new IllegalArgumentException("Resolved identifier for a bean must not be null");
            }
            if (this.internalAddItemAtEnd(itemId, this.createBeanItem(bean), false) == null) continue;
            modified = true;
        }
        if (modified) {
            if (this.isFiltered()) {
                this.doFilterContainer(!this.getFilters().isEmpty());
            }
            if (this.visibleNewItemsWasAdded(origSize)) {
                int firstPosition = origSize;
                Object firstItemId = this.getVisibleItemIds().get(firstPosition);
                int affectedItems = this.size() - origSize;
                this.fireItemsAdded(firstPosition, firstItemId, affectedItems);
            }
        }
    }

    private boolean visibleNewItemsWasAdded(int origSize) {
        return this.size() > origSize;
    }

    protected IDTYPE resolveBeanId(BEANTYPE bean) {
        if (this.beanIdResolver == null) {
            throw new IllegalStateException("Bean item identifier resolver is required.");
        }
        return this.beanIdResolver.getIdForBean(bean);
    }

    protected void setBeanIdResolver(BeanIdResolver<IDTYPE, BEANTYPE> beanIdResolver) {
        this.beanIdResolver = beanIdResolver;
    }

    public BeanIdResolver<IDTYPE, BEANTYPE> getBeanIdResolver() {
        return this.beanIdResolver;
    }

    protected BeanIdResolver<IDTYPE, BEANTYPE> createBeanPropertyResolver(Object propertyId) {
        return new PropertyBasedBeanIdResolver(propertyId);
    }

    @Override
    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.addPropertySetChangeListener(listener);
    }

    @Override
    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.removePropertySetChangeListener(listener);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use addNestedContainerProperty(String) to add container properties to a " + this.getClass().getSimpleName());
    }

    protected final boolean addContainerProperty(String propertyId, VaadinPropertyDescriptor<BEANTYPE> propertyDescriptor) {
        if (null == propertyId || null == propertyDescriptor) {
            return false;
        }
        if (this.model.containsKey(propertyId)) {
            return false;
        }
        this.model.put(propertyId, propertyDescriptor);
        for (BeanItem<BEANTYPE> item : this.itemIdToItem.values()) {
            item.addItemProperty(propertyId, propertyDescriptor.createProperty(item.getBean()));
        }
        this.fireContainerPropertySetChange();
        return true;
    }

    public boolean addNestedContainerProperty(String propertyId) {
        return this.addContainerProperty(propertyId, new NestedPropertyDescriptor<BEANTYPE>(propertyId, this.type));
    }

    public void addNestedContainerBean(String propertyId) {
        Class<?> propertyType = this.getType(propertyId);
        LinkedHashMap<String, VaadinPropertyDescriptor<?>> pds = BeanItem.getPropertyDescriptors(propertyType);
        for (String subPropertyId : pds.keySet()) {
            String qualifiedPropertyId = propertyId + "." + subPropertyId;
            NestedPropertyDescriptor<BEANTYPE> pd = new NestedPropertyDescriptor<BEANTYPE>(qualifiedPropertyId, this.type);
            this.model.put(qualifiedPropertyId, pd);
            this.model.remove(propertyId);
            for (BeanItem<BEANTYPE> item : this.itemIdToItem.values()) {
                item.addItemProperty(qualifiedPropertyId, pd.createProperty(item.getBean()));
                item.removeItemProperty(propertyId);
            }
        }
        this.fireContainerPropertySetChange();
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        if (!this.model.containsKey(propertyId)) {
            return false;
        }
        this.model.remove(propertyId);
        for (Object id : this.getAllItemIds()) {
            ((PropertysetItem)this.getUnfilteredItem(id)).removeItemProperty(propertyId);
        }
        this.fireContainerPropertySetChange();
        return true;
    }

    @Deprecated
    protected class PropertyBasedBeanIdResolver
    implements BeanIdResolver<IDTYPE, BEANTYPE> {
        private final Object propertyId;

        public PropertyBasedBeanIdResolver(Object propertyId) {
            if (propertyId == null) {
                throw new IllegalArgumentException("Property identifier must not be null");
            }
            this.propertyId = propertyId;
        }

        @Override
        public IDTYPE getIdForBean(BEANTYPE bean) throws IllegalArgumentException {
            VaadinPropertyDescriptor pd = (VaadinPropertyDescriptor)AbstractBeanContainer.this.model.get(this.propertyId);
            if (null == pd) {
                throw new IllegalStateException("Property " + this.propertyId + " not found");
            }
            try {
                Property<?> property = pd.createProperty(bean);
                return property.getValue();
            }
            catch (MethodProperty.MethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Deprecated
    public static interface BeanIdResolver<IDTYPE, BEANTYPE>
    extends Serializable {
        public IDTYPE getIdForBean(BEANTYPE var1);
    }
}

