/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerGradientServerRpc;
import com.vaadin.v7.shared.ui.colorpicker.ColorPickerGradientState;
import com.vaadin.v7.ui.AbstractColorPicker;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.lang.reflect.Method;
import java.util.EventObject;

@Deprecated
public class ColorPickerGradient
extends AbstractComponent
implements ColorSelector {
    private static final Method COLOR_CHANGE_METHOD;
    private ColorPickerGradientServerRpc rpc = new ColorPickerGradientServerRpc(){

        public void select(int cursorX, int cursorY) {
            ColorPickerGradient.this.x = cursorX;
            ColorPickerGradient.this.y = cursorY;
            ColorPickerGradient.this.color = ColorPickerGradient.this.converter.calculate(ColorPickerGradient.this.x, ColorPickerGradient.this.y);
            ColorPickerGradient.this.fireColorChanged(ColorPickerGradient.this.color);
        }
    };
    private AbstractColorPicker.Coordinates2Color converter;
    private Color color;
    private int x = 0;
    private int y = 0;

    private ColorPickerGradient() {
        this.registerRpc((ServerRpc)this.rpc);
        this.getState().width = "220px";
        this.getState().height = "220px";
    }

    public ColorPickerGradient(String id, AbstractColorPicker.Coordinates2Color converter) {
        this();
        this.addStyleName(id);
        this.converter = converter;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        int[] coords = this.converter.calculate(c);
        this.x = coords[0];
        this.y = coords[1];
        this.getState().cursorX = this.x;
        this.getState().cursorY = this.y;
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    public void setBackgroundColor(Color color) {
        this.getState().bgColor = color.getCSS();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void fireColorChanged(Color color) {
        this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this, color)));
    }

    protected ColorPickerGradientState getState() {
        return (ColorPickerGradientState)super.getState();
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }
}

