/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.GeneratedVaadinComboBox;
import com.vaadin.flow.component.combobox.dataview.ComboBoxDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxLazyDataView;
import com.vaadin.flow.component.combobox.dataview.ComboBoxListDataView;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@JsModule.Container(value={@JsModule(value="./flow-component-renderer.js"), @JsModule(value="./comboBoxConnector.js")})
public class ComboBox<T>
extends GeneratedVaadinComboBox<ComboBox<T>, T>
implements HasSize,
HasValidation,
HasDataView<T, String, ComboBoxDataView<T>>,
HasListDataView<T, ComboBoxListDataView<T>>,
HasLazyDataView<T, String, ComboBoxLazyDataView<T>>,
HasHelper {
    private static final String PROP_INPUT_ELEMENT_VALUE = "_inputElementValue";
    private static final String PROP_SELECTED_ITEM = "selectedItem";
    private static final String PROP_VALUE = "value";
    private static final String PROP_CLIENT_SIDE_FILTER = "_clientSideFilter";
    private static final String PROP_OPENED = "opened";
    private static final String COUNT_QUERY_WITH_UNDEFINED_SIZE_ERROR_MESSAGE = "Trying to use exact size with a lazy loading component without either providing a count callback for the component to fetch the count of the items or a data provider that implements the size query. Provide the callback for fetching item count with%ncomboBox.getLazyDataView().withDefinedSize(CallbackDataProvider.CountCallback);%nor switch to undefined size with%ncomboBox.getLazyDataView().withUndefinedSize()";
    private Registration dataProviderListener = null;
    private boolean shouldForceServerSideFiltering = false;
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
        }
    };
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private Renderer<T> renderer;
    private boolean renderScheduled;
    private String lastFilter;
    private DataCommunicator<T> dataCommunicator;
    private Registration lazyOpenRegistration;
    private Registration clearFilterOnCloseRegistration;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private Registration dataGeneratorRegistration;
    private Element template;
    private int customValueListenersCount;
    private SerializableConsumer<String> filterSlot = (SerializableConsumer & Serializable)filter -> {};
    private UserProvidedFilter userProvidedFilter = UserProvidedFilter.UNDECIDED;

    public ComboBox(int pageSize) {
        super(null, null, String.class, ComboBox::presentationToModel, ComboBox::modelToPresentation, true);
        this.dataGenerator.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> jsonObject.put("label", this.generateLabel(item)));
        this.setItemValuePath("key");
        this.setItemIdPath("key");
        this.setPageSize(pageSize);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.initConnector());
        this.setItems((ListDataProvider<T>)new DataCommunicator.EmptyDataProvider());
    }

    public ComboBox() {
        this(50);
    }

    public ComboBox(String label) {
        this();
        this.setLabel(label);
    }

    public ComboBox(String label, Collection<T> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public ComboBox(String label, T ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    private static <T> T presentationToModel(ComboBox<T> comboBox, String presentation) {
        if (presentation == null || comboBox.dataCommunicator == null) {
            return comboBox.getEmptyValue();
        }
        return (T)super.getKeyMapper().get(presentation);
    }

    private static <T> String modelToPresentation(ComboBox<T> comboBox, T model) {
        if (model == null) {
            return null;
        }
        return super.getKeyMapper().key(model);
    }

    public void setValue(T value) {
        if (this.dataCommunicator == null || this.dataCommunicator.getItemCount() == 0) {
            if (value == null) {
                return;
            }
            throw new IllegalStateException("Cannot set a value for a ComboBox without items. Use setItems to populate items into the ComboBox before setting a value.");
        }
        super.setValue(value);
        this.refreshValue();
    }

    private void refreshValue() {
        Object value = this.getValue();
        DataKeyMapper<T> keyMapper = this.getKeyMapper();
        if (value != null && keyMapper.has(value)) {
            value = keyMapper.get(keyMapper.key(value));
        }
        if (value == null) {
            this.getElement().setProperty(PROP_SELECTED_ITEM, null);
            this.getElement().setProperty(PROP_VALUE, "");
            this.getElement().setProperty(PROP_INPUT_ELEMENT_VALUE, "");
            return;
        }
        JsonObject json = Json.createObject();
        json.put("key", keyMapper.key(value));
        this.dataGenerator.generateData(value, json);
        this.setSelectedItem(json);
        this.getElement().setProperty(PROP_VALUE, keyMapper.key(value));
    }

    public void setRenderer(Renderer<T> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderer = renderer;
        if (this.template == null) {
            this.template = new Element("template");
            this.getElement().appendChild(new Element[]{this.template});
        }
        this.scheduleRender();
    }

    public ComboBoxListDataView<T> setItems(Collection<T> items) {
        return (ComboBoxListDataView)super.setItems(items);
    }

    public ComboBoxListDataView<T> setItems(ItemFilter<T> itemFilter, Collection<T> items) {
        ListDataProvider listDataProvider = DataProvider.ofCollection(items);
        this.setDataProvider(itemFilter, listDataProvider);
        return this.getListDataView();
    }

    public ComboBoxListDataView<T> setItems(ItemFilter<T> itemFilter, T ... items) {
        return this.setItems(itemFilter, (Collection<T>)new ArrayList<T>(Arrays.asList(items)));
    }

    @Deprecated
    public void setItems(Stream<T> streamOfItems) {
        this.setItems((ListDataProvider<T>)DataProvider.fromStream(streamOfItems));
    }

    public ComboBoxDataView<T> setItems(DataProvider<T, String> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    @Deprecated
    public ComboBoxDataView<T> setItems(InMemoryDataProvider<T> dataProvider) {
        throw new UnsupportedOperationException(String.format("ComboBox does not support setting a custom in-memory data provider without knowledge of the rules on how to convert internal text filter into a predicate applied to the data provider. Please use%nsetItems(InMemoryDataProvider<T>, SerializableFunction<String, SerializablePredicate<T>>)%noverloaded method instead", new Object[0]));
    }

    public ComboBoxDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider, SerializableFunction<String, SerializablePredicate<T>> filterConverter) {
        Objects.requireNonNull(filterConverter, "FilterConverter cannot be null");
        final ComboBox comboBox = this;
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, String, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider, (SerializableFunction)filterConverter){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            final /* synthetic */ SerializableFunction val$filterConverter;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                this.val$filterConverter = serializableFunction;
                super(x0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, String> query) {
                Optional componentInMemoryFilter = DataViewUtils.getComponentFilter((Component)comboBox);
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true).and(item -> ((SerializablePredicate)this.val$filterConverter.apply((Object)query.getFilter().orElse(""))).test(item)).and((Predicate)componentInMemoryFilter.orElse((SerializablePredicate & Serializable)item -> true));
            }
        };
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.NO;
        }
        return this.setItems((DataProvider<T, String>)convertedDataProvider);
    }

    public ComboBoxDataView<T> getGenericDataView() {
        return new ComboBoxDataView<T>(this.dataCommunicator, this);
    }

    public ComboBoxLazyDataView<T> setItems(BackEndDataProvider<T, String> dataProvider) {
        this.setDataProvider((DataProvider<T, String>)dataProvider);
        return this.getLazyDataView();
    }

    public ComboBoxLazyDataView<T> getLazyDataView() {
        return new ComboBoxLazyDataView<T>(this.dataCommunicator, (Component)this);
    }

    public ComboBoxListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getListDataView();
    }

    public ComboBoxListDataView<T> getListDataView() {
        return new ComboBoxListDataView<T>(this.dataCommunicator, this, this::onInMemoryFilterOrSortingChange);
    }

    @Deprecated
    public void setDataProvider(DataProvider<T, String> dataProvider) {
        this.setDataProvider(dataProvider, SerializableFunction.identity());
    }

    public <C> ComboBoxLazyDataView<T> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<T, C> fetchCallback, SerializableFunction<String, C> filterConverter) {
        Objects.requireNonNull(fetchCallback, "Fetch callback cannot be null");
        ComboBoxLazyDataView<T> lazyDataView = this.setItemsWithFilterConverter(fetchCallback, (CallbackDataProvider.CountCallback & Serializable)query -> {
            throw new IllegalStateException(COUNT_QUERY_WITH_UNDEFINED_SIZE_ERROR_MESSAGE);
        }, filterConverter);
        lazyDataView.setItemCountUnknown();
        return lazyDataView;
    }

    public <C> ComboBoxLazyDataView<T> setItemsWithFilterConverter(CallbackDataProvider.FetchCallback<T, C> fetchCallback, CallbackDataProvider.CountCallback<T, C> countCallback, SerializableFunction<String, C> filterConverter) {
        this.setDataProvider((DataProvider<T, C>)DataProvider.fromFilteringCallbacks(fetchCallback, countCallback), filterConverter);
        return this.getLazyDataView();
    }

    @Deprecated
    public <C> void setDataProvider(DataProvider<T, C> dataProvider, SerializableFunction<String, C> filterConverter) {
        boolean enableFetch;
        Objects.requireNonNull(dataProvider, "The data provider can not be null");
        Objects.requireNonNull(filterConverter, "filterConverter cannot be null");
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.YES;
        }
        boolean bl = enableFetch = dataProvider.isInMemory() && !DataCommunicator.EmptyDataProvider.class.isAssignableFrom(dataProvider.getClass());
        if (this.dataCommunicator == null) {
            this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> this.getElement().callJsFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode(), enableFetch);
            this.dataCommunicator.setPageSize(this.getPageSize());
        } else {
            this.dataCommunicator.setFetchEnabled(enableFetch);
        }
        this.scheduleRender();
        this.setValue(null);
        SerializableFunction & Serializable convertOrNull = (SerializableFunction & Serializable)filterText -> {
            if (filterText == null) {
                return null;
            }
            return filterConverter.apply(filterText);
        };
        SerializableConsumer providerFilterSlot = this.dataCommunicator.setDataProvider(dataProvider, convertOrNull.apply((Object)this.getFilterString()), false);
        this.filterSlot = (SerializableConsumer & Serializable)filter -> {
            if (!Objects.equals(filter, this.lastFilter)) {
                DataCommunicator.Filter objectFilter = new DataCommunicator.Filter(convertOrNull.apply(filter), filter.isEmpty());
                providerFilterSlot.accept((Object)objectFilter);
                this.lastFilter = filter;
            }
        };
        this.shouldForceServerSideFiltering = this.userProvidedFilter == UserProvidedFilter.YES;
        this.setupDataProviderListener(dataProvider);
        this.refreshAllData(this.shouldForceServerSideFiltering);
        this.userProvidedFilter = UserProvidedFilter.UNDECIDED;
        if (this.lazyOpenRegistration == null && !enableFetch) {
            this.lazyOpenRegistration = this.getElement().addPropertyChangeListener(PROP_OPENED, this::executeRegistration);
        }
    }

    private void clearFilterOnClose(PropertyChangeEvent event) {
        if (Boolean.FALSE.equals(event.getValue()) && this.lastFilter != null && !this.lastFilter.isEmpty()) {
            this.clearClientSideFilterAndUpdateInMemoryFilter();
        }
    }

    private void executeRegistration(PropertyChangeEvent event) {
        if (Boolean.TRUE.equals(event.getValue())) {
            this.removeLazyOpenRegistration();
            this.dataCommunicator.setFetchEnabled(true);
        }
    }

    private <C> void setupDataProviderListener(DataProvider<T, C> dataProvider) {
        if (this.dataProviderListener != null) {
            this.dataProviderListener.remove();
        }
        this.dataProviderListener = dataProvider.addDataProviderListener((DataProviderListener & Serializable)e -> {
            if (e instanceof DataChangeEvent.DataRefreshEvent) {
                this.dataCommunicator.refresh(((DataChangeEvent.DataRefreshEvent)e).getItem());
            } else {
                this.refreshAllData(this.shouldForceServerSideFiltering);
            }
        });
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        DataProvider<T, ?> dataProvider = this.getDataProvider();
        if (dataProvider != null && this.dataProviderListener == null) {
            this.setupDataProviderListener(dataProvider);
        }
        this.clearFilterOnCloseRegistration = this.getElement().addPropertyChangeListener(PROP_OPENED, this::clearFilterOnClose);
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListener != null) {
            this.dataProviderListener.remove();
            this.dataProviderListener = null;
        }
        this.removeLazyOpenRegistration();
        if (this.clearFilterOnCloseRegistration != null) {
            this.clearFilterOnCloseRegistration.remove();
            this.clearFilterOnCloseRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    private void refreshAllData(boolean forceServerSideFiltering) {
        this.setClientSideFilter(!forceServerSideFiltering && (double)this.dataCommunicator.getItemCount() <= this.getPageSizeDouble());
        this.reset();
    }

    @Deprecated
    public void setDataProvider(ListDataProvider<T> listDataProvider) {
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.NO;
        }
        ItemFilter<Object> & Serializable defaultItemFilter = (ItemFilter<Object> & Serializable)(item, filterText) -> this.generateLabel(item).toLowerCase(this.getLocale()).contains(filterText.toLowerCase(this.getLocale()));
        this.setDataProvider(defaultItemFilter, listDataProvider);
    }

    @Deprecated
    public void setDataProvider(FetchItemsCallback<T> fetchItems, SerializableFunction<String, Integer> sizeCallback) {
        Objects.requireNonNull(fetchItems, "Fetch callback cannot be null");
        Objects.requireNonNull(sizeCallback, "Size callback cannot be null");
        this.userProvidedFilter = UserProvidedFilter.YES;
        this.setDataProvider((DataProvider<T, String>)new CallbackDataProvider((CallbackDataProvider.FetchCallback & Serializable)query -> fetchItems.fetchItems(query.getFilter().orElse(""), query.getOffset(), query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> (Integer)sizeCallback.apply((Object)query.getFilter().orElse(""))));
    }

    @Deprecated
    public void setDataProvider(ItemFilter<T> itemFilter, ListDataProvider<T> listDataProvider) {
        Objects.requireNonNull(listDataProvider, "List data provider cannot be null");
        this.setDataProvider((DataProvider)listDataProvider, (SerializableFunction)(SerializableFunction & Serializable)filterText -> {
            Optional componentInMemoryFilter = DataViewUtils.getComponentFilter((Component)this);
            return (SerializablePredicate & Serializable)item -> itemFilter.test((Object)item, (String)filterText) && ((SerializablePredicate)componentInMemoryFilter.orElse((SerializablePredicate & Serializable)ignore -> true)).test(item);
        });
    }

    public ComboBoxListDataView<T> setItems(ItemFilter<T> itemFilter, ListDataProvider<T> listDataProvider) {
        this.setDataProvider(itemFilter, listDataProvider);
        return this.getListDataView();
    }

    public DataProvider<T, ?> getDataProvider() {
        if (this.dataCommunicator != null) {
            return this.dataCommunicator.getDataProvider();
        }
        return null;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.reset();
        if (this.getValue() != null) {
            this.refreshValue();
        }
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size should be greater than zero.");
        }
        super.setPageSize(pageSize);
        if (this.dataCommunicator != null) {
            this.dataCommunicator.setPageSize(pageSize);
        }
        this.reset();
    }

    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 50);
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setAllowCustomValue(boolean allowCustomValue) {
        super.setAllowCustomValue(allowCustomValue);
    }

    public boolean isAllowCustomValue() {
        return this.isAllowCustomValueBoolean();
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public T getEmptyValue() {
        return null;
    }

    @Override
    public Registration addCustomValueSetListener(ComponentEventListener<GeneratedVaadinComboBox.CustomValueSetEvent<ComboBox<T>>> listener) {
        this.setAllowCustomValue(true);
        ++this.customValueListenersCount;
        Registration registration = super.addCustomValueSetListener(listener);
        return new CustomValueRegistration(registration);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.enableClientValidation", new Serializable[]{Boolean.valueOf(!requiredIndicatorVisible)}));
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisibleBoolean();
    }

    public ComboBoxLazyDataView<T> setItems(CallbackDataProvider.FetchCallback<T, String> fetchCallback) {
        return (ComboBoxLazyDataView)super.setItems(fetchCallback);
    }

    public ComboBoxLazyDataView<T> setItems(CallbackDataProvider.FetchCallback<T, String> fetchCallback, CallbackDataProvider.CountCallback<T, String> countCallback) {
        return (ComboBoxLazyDataView)super.setItems(fetchCallback, countCallback);
    }

    CompositeDataGenerator<T> getDataGenerator() {
        return this.dataGenerator;
    }

    private String generateLabel(T item) {
        if (item == null) {
            return "";
        }
        String label = this.getItemLabelGenerator().apply(item);
        if (label == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        return label;
    }

    private void scheduleRender() {
        if (this.renderScheduled || this.dataCommunicator == null || this.renderer == null) {
            return;
        }
        this.renderScheduled = true;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            Rendering rendering;
            if (this.dataGeneratorRegistration != null) {
                this.dataGeneratorRegistration.remove();
                this.dataGeneratorRegistration = null;
            }
            if ((rendering = this.renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper(), this.template)).getDataGenerator().isPresent()) {
                this.dataGeneratorRegistration = this.dataGenerator.addDataGenerator((DataGenerator)rendering.getDataGenerator().get());
            }
            this.reset();
        });
    }

    @ClientCallable
    private void confirmUpdate(int id) {
        this.dataCommunicator.confirmUpdate(id);
    }

    @ClientCallable
    private void setRequestedRange(int start, int length, String filter) {
        this.dataCommunicator.setRequestedRange(start, length);
        this.filterSlot.accept((Object)filter);
        this.getElement().executeJs("this._selectedKey=$0", new Serializable[]{this.getValue() != null ? this.getKeyMapper().key(this.getValue()) : ""});
    }

    @ClientCallable
    private void resetDataCommunicator() {
        if (this.lastFilter == null || this.lastFilter.isEmpty()) {
            this.dataCommunicator.reset();
        } else {
            String filter = this.lastFilter;
            this.lastFilter = null;
            this.filterSlot.accept((Object)filter);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void initConnector() {
        this.getElement().executeJs("window.Vaadin.Flow.comboBoxConnector.initLazy(this)", new Serializable[0]);
    }

    private DataKeyMapper<T> getKeyMapper() {
        return this.dataCommunicator.getKeyMapper();
    }

    private void setClientSideFilter(boolean clientSideFilter) {
        this.getElement().setProperty(PROP_CLIENT_SIDE_FILTER, clientSideFilter);
    }

    private void reset() {
        this.lastFilter = null;
        if (this.dataCommunicator != null) {
            this.dataCommunicator.setRequestedRange(0, 0);
            this.dataCommunicator.reset();
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("if($0.$connector) $0.$connector.reset();", new Serializable[]{this.getElement()}));
    }

    private void removeLazyOpenRegistration() {
        if (this.lazyOpenRegistration != null) {
            this.lazyOpenRegistration.remove();
            this.lazyOpenRegistration = null;
        }
    }

    private void onInMemoryFilterOrSortingChange(SerializablePredicate<T> filter, SerializableComparator<T> sortComparator) {
        this.dataCommunicator.setInMemorySorting(sortComparator);
        this.clearClientSideFilterAndUpdateInMemoryFilter();
    }

    private void clearClientSideFilterAndUpdateInMemoryFilter() {
        this.lastFilter = null;
        this.filterSlot.accept((Object)"");
        this.reset();
    }

    private static enum UserProvidedFilter {
        UNDECIDED,
        YES,
        NO;

    }

    @FunctionalInterface
    public static interface ItemFilter<T>
    extends SerializableBiPredicate<T, String> {
        public boolean test(T var1, String var2);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private transient List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
            ComboBox.this.getElement().setProperty("size", (double)size);
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", new Serializable[]{Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()), ComboBox.this.lastFilter});
        }

        public void clear(int start, int length) {
        }

        public void commit(int updateId) {
            this.enqueue("$connector.confirm", new Serializable[]{Integer.valueOf(updateId), ComboBox.this.lastFilter});
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> ComboBox.this.getElement().callJsFunction(name, arguments));
        }
    }

    private class CustomValueRegistration
    implements Registration {
        private Registration delegate;

        private CustomValueRegistration(Registration delegate) {
            this.delegate = delegate;
        }

        public void remove() {
            if (this.delegate != null) {
                this.delegate.remove();
                ComboBox.this.customValueListenersCount--;
                if (ComboBox.this.customValueListenersCount == 0) {
                    ComboBox.this.setAllowCustomValue(false);
                }
                this.delegate = null;
            }
        }
    }

    @FunctionalInterface
    public static interface FetchItemsCallback<T>
    extends Serializable {
        public Stream<T> fetchItems(String var1, int var2, int var3);
    }
}

