/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.annotation.NormalRouteScoped;
import com.vaadin.cdi.annotation.RouteScopeOwner;
import com.vaadin.cdi.annotation.RouteScoped;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;

@Dependent
class DeploymentValidator {
    @Inject
    private BeanManager beanManager;
    private final List<BeanValidator> validators = Arrays.asList(new NormalScopedComponentValidator(), new AbsentOwnerOfNonRouteComponentValidator(), new OwnerIsNotRouteComponentValidator(), new NonRouteScopedHaveOwnerValidator());

    DeploymentValidator() {
    }

    void validate(Set<BeanInfo> infoSet, Consumer<Throwable> problemConsumer) {
        infoSet.forEach(info -> this.validateBean((BeanInfo)info, problemConsumer));
    }

    private void validateBean(BeanInfo beanInfo, Consumer<Throwable> problemConsumer) {
        this.validators.stream().filter(validator -> validator.isInvalid(beanInfo)).map(validator -> new DeploymentProblem(validator.getErrorMessage(beanInfo), beanInfo.getBaseType(), validator.getErrorCode())).forEach(problemConsumer);
    }

    private static boolean isNonRouteComponent(Type type) {
        if (!(type instanceof Class)) {
            return true;
        }
        Class clazz = (Class)type;
        return !clazz.isAnnotationPresent(Route.class) && !HasErrorParameter.class.isAssignableFrom(clazz) && !RouterLayout.class.isAssignableFrom(clazz);
    }

    private class NonRouteScopedHaveOwnerValidator
    implements BeanValidator {
        private NonRouteScopedHaveOwnerValidator() {
        }

        @Override
        public boolean isInvalid(BeanInfo beanInfo) {
            return !beanInfo.isRouteScoped() && beanInfo.getRouteScopeOwner().isPresent();
        }

        @Override
        public DeploymentProblem.ErrorCode getErrorCode() {
            return DeploymentProblem.ErrorCode.NON_ROUTE_SCOPED_HAVE_OWNER;
        }

        @Override
        public String getErrorMessage(BeanInfo beanInfo) {
            return String.format("'%s' should be '@%s' or '@%s' to have a '@%s'.", beanInfo.getBaseType().getTypeName(), RouteScoped.class.getSimpleName(), NormalRouteScoped.class.getSimpleName(), RouteScopeOwner.class.getSimpleName());
        }
    }

    private class AbsentOwnerOfNonRouteComponentValidator
    implements BeanValidator {
        private AbsentOwnerOfNonRouteComponentValidator() {
        }

        @Override
        public boolean isInvalid(BeanInfo beanInfo) {
            return beanInfo.isRouteScoped() && DeploymentValidator.isNonRouteComponent(beanInfo.getBaseType()) && !beanInfo.getRouteScopeOwner().isPresent();
        }

        @Override
        public DeploymentProblem.ErrorCode getErrorCode() {
            return DeploymentProblem.ErrorCode.ABSENT_OWNER_OF_NON_ROUTE_COMPONENT;
        }

        @Override
        public String getErrorMessage(BeanInfo beanInfo) {
            return String.format("'%s' is not a route component, need a '@%s'.", beanInfo.getBaseType().getTypeName(), RouteScopeOwner.class.getSimpleName());
        }
    }

    private class OwnerIsNotRouteComponentValidator
    implements BeanValidator {
        private OwnerIsNotRouteComponentValidator() {
        }

        @Override
        public boolean isInvalid(BeanInfo beanInfo) {
            return beanInfo.isRouteScoped() && beanInfo.getRouteScopeOwner().map(RouteScopeOwner::value).filter(x$0 -> DeploymentValidator.isNonRouteComponent(x$0)).isPresent();
        }

        @Override
        public DeploymentProblem.ErrorCode getErrorCode() {
            return DeploymentProblem.ErrorCode.OWNER_IS_NOT_ROUTE_COMPONENT;
        }

        @Override
        public String getErrorMessage(BeanInfo beanInfo) {
            return String.format("'@%s' should define a route component on '%s'.", RouteScopeOwner.class.getSimpleName(), beanInfo.getBaseType().getTypeName());
        }
    }

    private class NormalScopedComponentValidator
    implements BeanValidator {
        private NormalScopedComponentValidator() {
        }

        @Override
        public boolean isInvalid(BeanInfo beanInfo) {
            return beanInfo.isComponent() && beanInfo.isNormalScoped(DeploymentValidator.this.beanManager);
        }

        @Override
        public DeploymentProblem.ErrorCode getErrorCode() {
            return DeploymentProblem.ErrorCode.NORMAL_SCOPED_COMPONENT;
        }

        @Override
        public String getErrorMessage(BeanInfo beanInfo) {
            return String.format("Normal scoped Vaadin components are not supported. '%s' should not belong to a normal scope.", beanInfo.getBaseType().getTypeName());
        }
    }

    private static interface BeanValidator {
        public boolean isInvalid(BeanInfo var1);

        public DeploymentProblem.ErrorCode getErrorCode();

        public String getErrorMessage(BeanInfo var1);
    }

    static class DeploymentProblem
    extends Throwable {
        private final Type baseType;
        private final ErrorCode errorCode;

        private DeploymentProblem(String message, Type baseType, ErrorCode errorCode) {
            super(message);
            this.baseType = baseType;
            this.errorCode = errorCode;
        }

        Type getBaseType() {
            return this.baseType;
        }

        ErrorCode getErrorCode() {
            return this.errorCode;
        }

        static enum ErrorCode {
            NORMAL_SCOPED_COMPONENT,
            NON_ROUTE_SCOPED_HAVE_OWNER,
            ABSENT_OWNER_OF_NON_ROUTE_COMPONENT,
            OWNER_IS_NOT_ROUTE_COMPONENT;

        }
    }

    static class BeanInfo {
        private final Bean<?> bean;
        private final Annotated annotated;

        BeanInfo(Bean<?> bean, Annotated annotated) {
            this.bean = bean;
            this.annotated = annotated;
        }

        Type getBaseType() {
            return this.annotated.getBaseType();
        }

        private boolean isNormalScoped(BeanManager bm) {
            return bm.isNormalScope(this.bean.getScope());
        }

        private boolean isRouteScoped() {
            Class scope = this.bean.getScope();
            return scope.equals(RouteScoped.class) || scope.equals(NormalRouteScoped.class);
        }

        private boolean isComponent() {
            for (Type type : this.bean.getTypes()) {
                if (!(type instanceof Class) || !Component.class.isAssignableFrom((Class)type)) continue;
                return true;
            }
            return false;
        }

        private Optional<RouteScopeOwner> getRouteScopeOwner() {
            for (Annotation ann : this.bean.getQualifiers()) {
                if (!(ann instanceof RouteScopeOwner)) continue;
                return Optional.of((RouteScopeOwner)ann);
            }
            return Optional.empty();
        }
    }
}

