/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.CommandsAndHandlers;
import com.vaadin.signals.impl.Snapshot;
import com.vaadin.signals.impl.TransientListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class SignalTree {
    private final Map<Id, List<TransientListener>> observers = new HashMap<Id, List<TransientListener>>();
    private final Id id = Id.random();
    private final ReentrantLock lock = new ReentrantLock();
    private final Type type;
    private final List<BiConsumer<SignalCommand, CommandResult>> subscribers = new ArrayList<BiConsumer<SignalCommand, CommandResult>>();

    protected SignalTree(Type type) {
        assert (type != null);
        this.type = type;
    }

    public Id id() {
        return this.id;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    protected boolean hasLock() {
        return this.lock.isHeldByCurrentThread();
    }

    protected <T> T getWithLock(Supplier<T> action) {
        this.lock.lock();
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void runWithLock(Runnable action) {
        this.lock.lock();
        try {
            action.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Runnable wrapWithLock(Runnable action) {
        return () -> this.runWithLock(action);
    }

    public Runnable observeNextChange(Id nodeId, TransientListener observer) {
        assert (nodeId != null);
        assert (observer != null);
        return this.getWithLock(() -> {
            assert (this.submitted().nodes().containsKey(nodeId));
            List list = this.observers.computeIfAbsent(nodeId, ignore -> new ArrayList());
            list.add(observer);
            return this.wrapWithLock(() -> list.remove(observer));
        });
    }

    protected void notifyObservers(Snapshot oldSnapshot, Snapshot newSnapshot) {
        if (oldSnapshot == newSnapshot) {
            return;
        }
        this.runWithLock(() -> Map.copyOf(this.observers).forEach((nodeId, list) -> {
            Node.Data newNode;
            Node.Data oldNode = oldSnapshot.data((Id)nodeId).orElse(Node.EMPTY);
            if (oldNode != (newNode = newSnapshot.data((Id)nodeId).orElse(Node.EMPTY))) {
                List<TransientListener> copy = List.copyOf(list);
                list.clear();
                for (TransientListener observer : copy) {
                    boolean listenToNext = observer.invoke();
                    if (!listenToNext) continue;
                    list.add(observer);
                }
            }
        }));
    }

    public abstract Snapshot submitted();

    public abstract Snapshot confirmed();

    public void commitSingleCommand(SignalCommand command, Consumer<CommandResult> resultHandler) {
        assert (command != null);
        CommandsAndHandlers commands = new CommandsAndHandlers(command, resultHandler);
        this.runWithLock(() -> {
            PendingCommit commit = this.prepareCommit(commands);
            if (commit.canCommit()) {
                commit.applyChanges();
                commit.publishChanges();
            } else {
                commit.markAsAborted();
            }
        });
    }

    public void commitSingleCommand(SignalCommand command) {
        this.commitSingleCommand(command, null);
    }

    public abstract PendingCommit prepareCommit(CommandsAndHandlers var1);

    public Type type() {
        return this.type;
    }

    public Runnable subscribeToProcessed(BiConsumer<SignalCommand, CommandResult> subscriber) {
        assert (subscriber != null);
        return this.getWithLock(() -> {
            this.subscribers.add(subscriber);
            return this.wrapWithLock(() -> this.subscribers.remove(subscriber));
        });
    }

    protected void notifyProcessedCommandSubscribers(List<SignalCommand> commands, Map<Id, CommandResult> results) {
        assert (this.hasLock());
        for (SignalCommand command : commands) {
            for (BiConsumer<SignalCommand, CommandResult> subscriber : this.subscribers) {
                subscriber.accept(command, results.get(command.commandId()));
            }
        }
    }

    public static enum Type {
        ASYNCHRONOUS,
        COMPUTED,
        SYNCHRONOUS;

    }

    public static interface PendingCommit {
        public boolean canCommit();

        public void applyChanges();

        public void markAsAborted();

        public void publishChanges();
    }
}

