/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJson;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonArray;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonBoolean;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonFactory;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNumber;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonObject;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonString;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJreJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonArrayContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonUtil;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class LicenseCheckerJreJsonArray
extends LicenseCheckerJreJsonValue
implements LicenseCheckerJsonArray {
    private static final long serialVersionUID = 1L;
    private transient ArrayList<LicenseCheckerJsonValue> arrayValues = new ArrayList();
    private transient LicenseCheckerJsonFactory factory;

    public LicenseCheckerJreJsonArray(LicenseCheckerJsonFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        switch (this.length()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return this.get(0).asNumber();
            }
        }
        return Double.NaN;
    }

    @Override
    public String asString() {
        StringBuilder toReturn = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                toReturn.append(", ");
            }
            toReturn.append(this.get(i).asString());
        }
        return toReturn.toString();
    }

    public LicenseCheckerJsonValue get(int index) {
        return this.arrayValues.get(index);
    }

    @Override
    public LicenseCheckerJsonArray getArray(int index) {
        return (LicenseCheckerJsonArray)this.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return ((LicenseCheckerJsonBoolean)this.get(index)).getBoolean();
    }

    @Override
    public double getNumber(int index) {
        return ((LicenseCheckerJsonNumber)this.get(index)).getNumber();
    }

    @Override
    public LicenseCheckerJsonObject getObject(int index) {
        return (LicenseCheckerJsonObject)this.get(index);
    }

    @Override
    public Object getObject() {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (LicenseCheckerJsonValue val : this.arrayValues) {
            objs.add(((LicenseCheckerJreJsonValue)val).getObject());
        }
        return objs;
    }

    @Override
    public String getString(int index) {
        return ((LicenseCheckerJsonString)this.get(index)).getString();
    }

    @Override
    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.ARRAY;
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return this.getObject().equals(((LicenseCheckerJreJsonValue)value).getObject());
    }

    @Override
    public int length() {
        return this.arrayValues.size();
    }

    @Override
    public void remove(int index) {
        this.arrayValues.remove(index);
    }

    @Override
    public void set(int index, LicenseCheckerJsonValue value) {
        if (value == null) {
            value = this.factory.createNull();
        }
        if (index == this.arrayValues.size()) {
            this.arrayValues.add(index, value);
        } else {
            this.arrayValues.set(index, value);
        }
    }

    @Override
    public void set(int index, String string) {
        this.set(index, this.factory.create(string));
    }

    @Override
    public void set(int index, double number) {
        this.set(index, this.factory.create(number));
    }

    @Override
    public void set(int index, boolean bool) {
        this.set(index, this.factory.create(bool));
    }

    @Override
    public String toJson() {
        return LicenseCheckerJsonUtil.stringify(this);
    }

    @Override
    public void traverse(LicenseCheckerJsonVisitor visitor, LicenseCheckerJsonContext ctx) {
        if (visitor.visit(this, ctx)) {
            LicenseCheckerJsonArrayContext arrayCtx = new LicenseCheckerJsonArrayContext(this);
            for (int i = 0; i < this.length(); ++i) {
                arrayCtx.setCurrentIndex(i);
                if (!visitor.visitIndex(arrayCtx.getCurrentIndex(), arrayCtx)) continue;
                visitor.accept(this.get(i), arrayCtx);
                arrayCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        LicenseCheckerJreJsonArray instance = (LicenseCheckerJreJsonArray)LicenseCheckerJreJsonArray.parseJson(stream);
        this.factory = LicenseCheckerJson.instance();
        this.arrayValues = instance.arrayValues;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }
}

