/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.Util;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProKeyValidator {
    private static final String UNABLE_TO_VALIDATE_SUBSCRIPTION = "Unable to validate subscription. Please go to https://vaadin.com/pro/validate-license to check that your subscription is active. For troubleshooting steps, see https://vaadin.com/licensing-faq-and-troubleshooting.";
    private static final String LICENSE_VALIDATION_URL = "https://tools.vaadin.com/vaadin-license-server/licenses/pro";
    private static final String[] PROPERTIES = new String[]{"java.vendor", "java.version", "os.arch", "os.name", "os.version"};

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    public static void validate(Product product, ProKey proKey, String machineId) {
        if (proKey == null) {
            ProKeyValidator.getLogger().fine("No pro key found to validate");
            throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION);
        }
        ProKeyValidator.getLogger().fine("Validating pro key for " + product);
        if (History.isRecentlyValidated(product)) {
            ProKeyValidator.getLogger().fine("Skipping check as product license was recently validated.");
            return;
        }
        try {
            JsonObject response = ProKeyValidator.queryServer(product, proKey, machineId);
            if (ProKeyValidator.validateServerResponse(product, response)) {
                History.setLastCheckTimeNow(product);
                History.setLastSubscription(product, response.getString("subscription"));
                return;
            }
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException e) {
            ProKeyValidator.getLogger().log(Level.WARNING, "Unable to validate the license, please check your internet connection");
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION, e);
        }
        throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION);
    }

    public static String getSubscription(Product product, ProKey proKey) {
        if (proKey == null) {
            ProKeyValidator.getLogger().fine("No pro key found to get subscription");
            return null;
        }
        return History.getLastSubscription(product);
    }

    private static boolean validateServerResponse(Product product, JsonObject response) {
        ProKeyValidator.getLogger().info("Validating license for " + product.getName() + " " + product.getVersion());
        String result = response.getString("result");
        String message = response.getString("message");
        if (message != null && !message.isEmpty()) {
            ProKeyValidator.getLogger().info(message);
        }
        return "ok".equals(result);
    }

    private static JsonObject queryServer(Product product, ProKey proKey, String machineId) throws IOException {
        URL url = new URL(LICENSE_VALIDATION_URL);
        URLConnection http = url.openConnection();
        http.setRequestProperty("check-source", "java");
        http.setRequestProperty("machine-id", machineId);
        http.setRequestProperty("product-name", product.getName());
        http.setRequestProperty("product-version", product.getVersion());
        for (String property : PROPERTIES) {
            String value = System.getProperty(property);
            if (value == null) continue;
            http.setRequestProperty("prop-" + property.replace(".", "-"), value);
        }
        http.setRequestProperty("product-version", product.getVersion());
        http.setRequestProperty("Cookie", "proKey=" + proKey.getProKey());
        http.setConnectTimeout(5000);
        http.setReadTimeout(5000);
        http.connect();
        try (InputStream in = http.getInputStream();){
            String response = Util.toString(in);
            JsonObject jsonObject = Json.parse((String)response);
            return jsonObject;
        }
    }
}

