/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalProKey {
    private static ProKey read(File proKeyLocation) throws IOException {
        if (!proKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(proKeyLocation);){
            ProKey proKey = ProKey.fromJson(Util.toString(is));
            return proKey;
        }
    }

    public static File getLocation() {
        String userHome = System.getProperty("user.home");
        return new File(new File(userHome, ".vaadin"), "proKey");
    }

    public static ProKey get() {
        ProKey proKey = LocalProKey.getSystemProperty();
        if (proKey != null) {
            LocalProKey.getLogger().fine("Using proKey from system property");
            return proKey;
        }
        proKey = LocalProKey.getEnvironmentVariable();
        if (proKey != null) {
            LocalProKey.getLogger().fine("Using proKey from environment variable");
            return proKey;
        }
        File proKeyLocation = LocalProKey.getLocation();
        try {
            proKey = LocalProKey.read(proKeyLocation);
            LocalProKey.getLogger().fine("Found proKey in " + proKeyLocation);
            return proKey;
        }
        catch (IOException e) {
            LocalProKey.getLogger().log(Level.FINE, "Unable to read proKey", e);
            return null;
        }
    }

    private static ProKey getSystemProperty() {
        String value = System.getProperty("vaadin.proKey");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            LocalProKey.getLogger().warning("Unable to read pro key from the vaadin.proKey system property. The property must be of type -Dvaadin.proKey=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    private static ProKey getEnvironmentVariable() {
        String value = System.getenv("VAADIN_PRO_KEY");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        if (parts.length != 2) {
            LocalProKey.getLogger().warning("Unable to read pro key from the VAADIN_PRO_KEY environment variable. The value must be of type VAADIN_PRO_KEY=[vaadin.com login email]/[prokey]");
            return null;
        }
        return new ProKey(parts[0], parts[1]);
    }

    public static void write(ProKey proKey) {
        File proKeyLocation = LocalProKey.getLocation();
        File proKeyDirectory = LocalProKey.getLocation().getParentFile();
        if (!proKeyDirectory.exists()) {
            proKeyDirectory.mkdirs();
        }
        LocalProKey.getLogger().fine("Writing pro key to " + proKeyLocation);
        try (FileWriter writer = new FileWriter(proKeyLocation);){
            writer.write(proKey.toJson());
        }
        catch (IOException e) {
            LocalProKey.getLogger().log(Level.SEVERE, "Unable to write key to " + proKeyLocation, e);
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

