/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.ProKeyValidator;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import java.util.logging.Logger;

public class LicenseChecker {
    public static void checkLicenseFromStaticBlock(String productName, String productVersion) {
        try {
            LicenseChecker.checkLicense(productName, productVersion);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void checkLicense(String productName, String productVersion) {
        LicenseChecker.checkLicense(new Product(productName, productVersion));
    }

    public static void checkLicenseAsync(String productName, String productVersion, Callback callback) {
        new Thread(() -> {
            try {
                LicenseChecker.checkLicense(new Product(productName, productVersion));
                callback.ok();
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }).start();
    }

    private static void checkLicense(Product product) {
        LicenseChecker.getLogger().fine("Checking license for " + product);
        ProKey proKey = LocalProKey.get();
        if (proKey == null && (proKey = VaadinComIntegration.openBrowserAndWaitForKey(product)) != null) {
            LocalProKey.write(proKey);
        }
        ProKeyValidator.validate(product, proKey, MachineId.get());
    }

    public static Logger getLogger() {
        return Logger.getLogger(LicenseChecker.class.getName());
    }

    public static interface Callback {
        public void ok();

        public void failed(Exception var1);
    }
}

