/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.RequiredFieldConfigurator;
import com.vaadin.flow.data.validator.BeanValidator;
import com.vaadin.flow.internal.BeanUtil;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;

public class BeanValidationBinder<BEAN>
extends Binder<BEAN> {
    private final Class<BEAN> beanType;
    private RequiredFieldConfigurator requiredConfigurator = RequiredFieldConfigurator.DEFAULT;

    public BeanValidationBinder(Class<BEAN> beanType) {
        this(beanType, false);
    }

    public BeanValidationBinder(Class<BEAN> beanType, boolean scanNestedDefinitions) {
        super(beanType, scanNestedDefinitions);
        if (!BeanUtil.checkBeanValidationAvailable()) {
            throw new IllegalStateException(BeanValidationBinder.class.getSimpleName() + " cannot be used because a JSR-303 Bean Validation implementation not found on the classpath or could not be initialized. Use " + Binder.class.getSimpleName() + " instead");
        }
        this.beanType = beanType;
    }

    public void setRequiredConfigurator(RequiredFieldConfigurator configurator) {
        this.requiredConfigurator = configurator;
    }

    public RequiredFieldConfigurator getRequiredConfigurator() {
        return this.requiredConfigurator;
    }

    @Override
    protected Binder.BindingBuilder<BEAN, ?> configureBinding(Binder.BindingBuilder<BEAN, ?> binding, PropertyDefinition<BEAN, ?> definition) {
        Class<?> actualBeanType = this.findBeanType(this.beanType, definition);
        BeanValidator validator = new BeanValidator(actualBeanType, definition.getTopLevelName());
        if (this.requiredConfigurator != null) {
            this.configureRequired(binding, definition, validator);
        }
        return binding.withValidator(validator);
    }

    private Class<?> findBeanType(Class<BEAN> beanType, PropertyDefinition<BEAN, ?> definition) {
        if (definition instanceof BeanPropertySet.NestedBeanPropertyDefinition) {
            return ((BeanPropertySet.NestedBeanPropertyDefinition)definition).getParent().getType();
        }
        return beanType;
    }

    private void configureRequired(Binder.BindingBuilder<BEAN, ?> binding, PropertyDefinition<BEAN, ?> definition, BeanValidator validator) {
        assert (this.requiredConfigurator != null);
        Class<?> propertyHolderType = definition.getPropertyHolderType();
        BeanDescriptor descriptor = validator.getJavaxBeanValidator().getConstraintsForClass(propertyHolderType);
        PropertyDescriptor propertyDescriptor = descriptor.getConstraintsForProperty(definition.getTopLevelName());
        if (propertyDescriptor == null) {
            return;
        }
        if (propertyDescriptor.getConstraintDescriptors().stream().map(ConstraintDescriptor::getAnnotation).anyMatch(constraint -> this.requiredConfigurator.test(constraint, binding))) {
            binding.getField().setRequiredIndicatorVisible(true);
        }
    }
}

