/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.util.Utils;

public class OnDisconnectInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);
    private AsynchronousProcessor p;
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        if (AsynchronousProcessor.class.isAssignableFrom(config.framework().getAsyncSupport().getClass())) {
            this.p = (AsynchronousProcessor)AsynchronousProcessor.class.cast(config.framework().getAsyncSupport());
        }
        this.config = config;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        String uuid = r.uuid();
        if (Utils.closeMessage(request)) {
            AtmosphereResource ss = this.config.resourcesFactory().find(uuid);
            if (ss == null) {
                this.logger.debug("No Suspended Connection found for {}. Using the AtmosphereResource associated with the close message", (Object)uuid);
                ss = r;
            }
            if (ss == null) {
                this.logger.debug("Was unable to execute onDisconnect on {}", (Object)r.uuid());
                return Action.CONTINUE;
            }
            this.logger.debug("AtmosphereResource {} disconnected", (Object)uuid);
            ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(ss.getAtmosphereResourceEvent())).isClosedByClient(true);
            this.p.completeLifecycle(ss, false);
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Browser disconnection detection";
    }
}

