/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Arrays;

public class UserInfoHandler
implements CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-user-info")) {
            ProKey proKey = LocalProKey.get();
            String[] accessTo = new String[]{};
            if (proKey != null) {
                accessTo = this.queryAccessTo(proKey);
            }
            JsonObject userInfo = Json.createObject();
            if (proKey != null) {
                userInfo.put("proKey", proKey.getProKey());
            }
            JsonArray accessValues = (JsonArray)Arrays.stream(accessTo).map(Json::create).collect(JsonUtils.asArray());
            userInfo.put("accessTo", (JsonValue)accessValues);
            userInfo.put("reqId", data.getString("reqId"));
            devToolsInterface.send("copilot-user-info", userInfo);
            return true;
        }
        if (command.equals("log-in")) {
            ProKey proKey = LocalProKey.get();
            JsonObject response = Json.createObject();
            response.put("reqId", data.getString("reqId"));
            if (proKey == null) {
                LicenseChecker.checkLicense((String)"copilot", (String)CopilotVersion.getVersion(), (BuildType)BuildType.DEVELOPMENT, loginUrl -> {
                    response.put("loginUrl", loginUrl);
                    devToolsInterface.send("log-in-resp", response);
                });
            }
            return true;
        }
        return false;
    }

    private String[] queryAccessTo(ProKey proKey) {
        return new String[0];
    }
}

