/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PropertyManagerCacheRecord;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PropertyManager {
    @NotNull
    private static final AtomicInteger CACHE_DURATION_MILLIS = new AtomicInteger(0);
    @NotNull
    private static final Map<String, PropertyManagerCacheRecord> CACHE = new ConcurrentHashMap<String, PropertyManagerCacheRecord>();

    private PropertyManager() {
    }

    @Nullable
    public static String get(@NotNull String propertyName) {
        return PropertyManager.get(propertyName, null);
    }

    @Nullable
    public static String get(@NotNull String propertyName, @Nullable String defaultValue) {
        String alternativeEnvironmentVariableValue;
        PropertyManagerCacheRecord cacheRecord;
        int cacheDurationMillis = CACHE_DURATION_MILLIS.get();
        if (cacheDurationMillis > 0 && (cacheRecord = CACHE.get(propertyName)) != null && !cacheRecord.isExpired()) {
            return cacheRecord.stringValue(defaultValue);
        }
        String systemPropertyValue = StaticUtils.getSystemProperty(propertyName);
        if (systemPropertyValue != null) {
            if (cacheDurationMillis > 0) {
                CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, systemPropertyValue, cacheDurationMillis));
            }
            return systemPropertyValue;
        }
        String environmentVariableValue = StaticUtils.getEnvironmentVariable(propertyName);
        if (environmentVariableValue != null) {
            if (cacheDurationMillis > 0) {
                CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, environmentVariableValue, cacheDurationMillis));
            }
            return environmentVariableValue;
        }
        String alternativeEnvironmentVariableName = PropertyManager.generateEnvironmentVariableNameFromPropertyName(propertyName);
        if (!alternativeEnvironmentVariableName.equals(propertyName) && (alternativeEnvironmentVariableValue = StaticUtils.getEnvironmentVariable(alternativeEnvironmentVariableName)) != null) {
            if (cacheDurationMillis > 0) {
                CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, alternativeEnvironmentVariableValue, cacheDurationMillis));
            }
            return alternativeEnvironmentVariableValue;
        }
        if (cacheDurationMillis > 0) {
            CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, null, cacheDurationMillis));
        }
        return defaultValue;
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName) {
        return PropertyManager.getBoolean(propertyName, null);
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName, @Nullable Boolean defaultValue) {
        return PropertyManager.getBoolean(propertyName, defaultValue, false);
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName, @Nullable Boolean defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        PropertyManagerCacheRecord cacheRecord;
        int cacheDurationMillis = CACHE_DURATION_MILLIS.get();
        if (cacheDurationMillis > 0 && (cacheRecord = CACHE.get(propertyName)) != null && !cacheRecord.isExpired()) {
            return cacheRecord.booleanValue(defaultValue, throwOnInvalidValue);
        }
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        Boolean booleanValue = PropertyManager.parseBoolean(stringValue);
        if (booleanValue == null) {
            if (throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_BOOLEAN.get(PropertyManager.getIdentifierString(propertyName), stringValue));
            }
            return defaultValue;
        }
        return booleanValue;
    }

    @Nullable
    static Boolean parseBoolean(@NotNull String stringValue) {
        String lowerValue;
        switch (lowerValue = StaticUtils.toLowerCase(stringValue.trim())) {
            case "true": 
            case "t": 
            case "yes": 
            case "y": 
            case "on": 
            case "1": {
                return Boolean.TRUE;
            }
            case "false": 
            case "f": 
            case "no": 
            case "n": 
            case "off": 
            case "0": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName) {
        return PropertyManager.getInt(propertyName, null);
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName, @Nullable Integer defaultValue) {
        return PropertyManager.getInt(propertyName, defaultValue, false);
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName, @Nullable Integer defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        PropertyManagerCacheRecord cacheRecord;
        int cacheDurationMillis = CACHE_DURATION_MILLIS.get();
        if (cacheDurationMillis > 0 && (cacheRecord = CACHE.get(propertyName)) != null && !cacheRecord.isExpired()) {
            return cacheRecord.intValue(defaultValue, throwOnInvalidValue);
        }
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue.trim());
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_INT.get(PropertyManager.getIdentifierString(propertyName), stringValue), e);
            }
            return defaultValue;
        }
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName) {
        return PropertyManager.getLong(propertyName, null);
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName, @Nullable Long defaultValue) {
        return PropertyManager.getLong(propertyName, defaultValue, false);
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName, @Nullable Long defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        PropertyManagerCacheRecord cacheRecord;
        int cacheDurationMillis = CACHE_DURATION_MILLIS.get();
        if (cacheDurationMillis > 0 && (cacheRecord = CACHE.get(propertyName)) != null && !cacheRecord.isExpired()) {
            return cacheRecord.longValue(defaultValue, throwOnInvalidValue);
        }
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringValue.trim());
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_LONG.get(PropertyManager.getIdentifierString(propertyName), stringValue), e);
            }
            return defaultValue;
        }
    }

    @NotNull
    public static List<String> getCommaDelimitedList(@NotNull String propertyName) {
        return PropertyManager.getCommaDelimitedList(propertyName, true);
    }

    @NotNull
    public static List<String> getCommaDelimitedList(@NotNull String propertyName, boolean trimItems) {
        ArrayList<String> items = new ArrayList<String>();
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue != null) {
            int startPos = 0;
            while (true) {
                String substring;
                int commaPos;
                if ((commaPos = stringValue.indexOf(44, startPos)) < 0) {
                    substring = stringValue.substring(startPos);
                    if (trimItems) {
                        substring = substring.trim();
                    }
                    items.add(substring);
                    break;
                }
                substring = stringValue.substring(startPos, commaPos);
                if (trimItems) {
                    substring = substring.trim();
                }
                items.add(substring);
                startPos = commaPos + 1;
            }
        }
        return Collections.unmodifiableList(items);
    }

    @NotNull
    public static Properties getProperties(String ... propertyNames) {
        Properties properties = new Properties();
        for (String propertyName : propertyNames) {
            String propertyValue = PropertyManager.get(propertyName);
            if (propertyValue == null) continue;
            properties.setProperty(propertyName, propertyValue);
        }
        return properties;
    }

    @NotNull
    public static String generateEnvironmentVariableNameFromPropertyName(@NotNull String propertyName) {
        String upperPropertyName = StaticUtils.toUpperCase(propertyName.trim());
        int length = upperPropertyName.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = upperPropertyName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }

    @Nullable
    static String getIdentifierString(@NotNull String propertyName) {
        if (StaticUtils.getSystemProperty(propertyName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_SYSTEM_PROPERY_IDENTIFIER.get(propertyName);
        }
        if (StaticUtils.getEnvironmentVariable(propertyName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_ENVIRONMENT_VARIABLE_IDENTIFIER.get(propertyName);
        }
        String alternativeName = PropertyManager.generateEnvironmentVariableNameFromPropertyName(propertyName);
        if (StaticUtils.getEnvironmentVariable(alternativeName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_ENVIRONMENT_VARIABLE_IDENTIFIER.get(alternativeName);
        }
        return null;
    }

    public static int getCacheDurationMillis() {
        return CACHE_DURATION_MILLIS.get();
    }

    public static void setCacheDurationMillis(int cacheDurationMillis) {
        if (cacheDurationMillis > 0) {
            CACHE_DURATION_MILLIS.set(cacheDurationMillis);
        } else {
            CACHE_DURATION_MILLIS.set(0);
        }
    }

    @NotNull
    static Map<String, PropertyManagerCacheRecord> getCache() {
        return CACHE;
    }

    public static void populateCache() {
        String stringValue;
        String propertyName;
        PropertyManager.clearCache();
        int cacheDurationMillis = CACHE_DURATION_MILLIS.get();
        if (cacheDurationMillis <= 0) {
            return;
        }
        for (Map.Entry<String, String> envVar : StaticUtils.getEnvironmentVariables().entrySet()) {
            propertyName = envVar.getKey();
            stringValue = envVar.getValue();
            CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, stringValue, cacheDurationMillis));
        }
        for (Map.Entry<Object, Object> systemProperty : StaticUtils.getSystemProperties(new String[0]).entrySet()) {
            propertyName = String.valueOf(systemProperty.getKey());
            stringValue = String.valueOf(systemProperty.getValue());
            CACHE.put(propertyName, new PropertyManagerCacheRecord(propertyName, stringValue, cacheDurationMillis));
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }
}

