/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AbortedTransactionExtendedResult
extends ExtendedResult {
    @NotNull
    public static final String ABORTED_TRANSACTION_RESULT_OID = "1.3.6.1.1.21.4";
    private static final long serialVersionUID = 7521522597566232465L;
    @NotNull
    private final ASN1OctetString transactionID;

    public AbortedTransactionExtendedResult(@NotNull ASN1OctetString transactionID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Control[] controls) {
        super(0, resultCode, diagnosticMessage, matchedDN, referralURLs, ABORTED_TRANSACTION_RESULT_OID, transactionID, controls);
        Validator.ensureNotNull(transactionID, resultCode);
        this.transactionID = transactionID;
    }

    public AbortedTransactionExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        this.transactionID = extendedResult.getValue();
        if (this.transactionID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_ABORTED_TXN_NO_VALUE.get());
        }
    }

    @NotNull
    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_ABORTED_TXN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("AbortedTransactionExtendedResult(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("', resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(", oid=");
        buffer.append(ABORTED_TRANSACTION_RESULT_OID);
        Control[] responseControls = this.getResponseControls();
        if (responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

