/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.PooledReferralConnector;
import com.unboundid.ldap.sdk.ReferralConnectionPool;
import com.unboundid.util.NotNull;
import com.unboundid.util.WakeableSleeper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class PooledReferralConnectorBackgroundThread
extends Thread {
    @NotNull
    private final AtomicBoolean shutDownRequested;
    private final long checkIntervalMillis;
    @NotNull
    private final Map<String, List<ReferralConnectionPool>> poolsByHostPort;
    private final long maximumPoolAgeMillis;
    private final long maximumPoolIdleDurationMillis;
    @NotNull
    private final WakeableSleeper sleeper;

    PooledReferralConnectorBackgroundThread(@NotNull PooledReferralConnector referralConnector) {
        this.setName("Pooled Referral Connector Background Thread");
        this.setDaemon(true);
        this.poolsByHostPort = referralConnector.getPoolsByHostPort();
        this.checkIntervalMillis = referralConnector.getBackgroundThreadCheckIntervalMillis();
        this.maximumPoolAgeMillis = referralConnector.getMaximumPoolAgeMillis();
        this.maximumPoolIdleDurationMillis = referralConnector.getMaximumPoolIdleDurationMillis();
        this.shutDownRequested = new AtomicBoolean(false);
        this.sleeper = new WakeableSleeper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutDownRequested.get()) {
            Map<String, List<ReferralConnectionPool>> map = this.poolsByHostPort;
            synchronized (map) {
                long currentTime = System.currentTimeMillis();
                for (List<ReferralConnectionPool> poolList : this.poolsByHostPort.values()) {
                    Iterator<ReferralConnectionPool> iterator = poolList.iterator();
                    while (iterator.hasNext()) {
                        long poolIdleDurationMillis;
                        long poolAgeMillis;
                        ReferralConnectionPool pool = iterator.next();
                        if (this.maximumPoolAgeMillis > 0L && (poolAgeMillis = currentTime - pool.getPoolCreateTimeMillis()) > this.maximumPoolAgeMillis) {
                            iterator.remove();
                            pool.close();
                        }
                        if (this.maximumPoolIdleDurationMillis <= 0L || (poolIdleDurationMillis = currentTime - pool.getLastUsedTimeMillis()) <= this.maximumPoolIdleDurationMillis) continue;
                        iterator.remove();
                        pool.close();
                    }
                }
            }
            this.sleeper.sleep(this.checkIntervalMillis);
        }
    }

    void shutDown() {
        this.shutDownRequested.set(true);
        this.sleeper.wakeup();
    }
}

