/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.BehaviorConfigHandler;
import com.sun.faces.application.annotation.ComponentConfigHandler;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.application.annotation.ConverterConfigHandler;
import com.sun.faces.application.annotation.ListenerForScanner;
import com.sun.faces.application.annotation.ManagedBeanConfigHandler;
import com.sun.faces.application.annotation.NamedEventConfigHandler;
import com.sun.faces.application.annotation.RenderKitConfigHandler;
import com.sun.faces.application.annotation.ResourceDependencyScanner;
import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.application.annotation.Scanner;
import com.sun.faces.application.annotation.ValidatorConfigHandler;
import com.sun.faces.util.FacesLogger;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.SystemEvent;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;

public class AnnotationManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Scanner RESOURCE_DEPENDENCY_SCANNER = new ResourceDependencyScanner();
    private static final Scanner LISTENER_FOR_SCANNER = new ListenerForScanner();
    private static final Scanner[] BEHAVIOR_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] CLIENT_BEHAVIOR_RENDERER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] UICOMPONENT_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private static final Scanner[] VALIDATOR_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] CONVERTER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] RENDERER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private static final Scanner[] EVENTS_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private ConcurrentMap<Class<?>, Future<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>> cache = new ConcurrentHashMap(40, 0.75f, 32);

    public void applyConfigAnnotations(FacesContext ctx, Class<? extends Annotation> annotationType, Set<? extends Class> annotatedClasses) {
        if (annotatedClasses != null && !annotatedClasses.isEmpty()) {
            ConfigAnnotationHandler handler = this.getConfigAnnotationHandlers().get(annotationType);
            if (handler == null) {
                throw new IllegalStateException("Internal Error: No ConfigAnnotationHandler for type: " + annotationType);
            }
            for (Class clazz : annotatedClasses) {
                handler.collect(clazz, clazz.getAnnotation(annotationType));
            }
            handler.push(ctx);
        }
    }

    public void applyBehaviorAnnotations(FacesContext ctx, Behavior b) {
        this.applyAnnotations(ctx, b.getClass(), ProcessingTarget.Behavior, b);
        if (b instanceof ClientBehaviorBase) {
            ClientBehaviorRenderer behaviorRenderer;
            ClientBehaviorBase clientBehavior = (ClientBehaviorBase)b;
            String rendererType = clientBehavior.getRendererType();
            RenderKit renderKit = ctx.getRenderKit();
            if (null != rendererType && null != renderKit && null != (behaviorRenderer = renderKit.getClientBehaviorRenderer(rendererType))) {
                this.applyClientBehaviorRendererAnnotations(ctx, behaviorRenderer);
            }
        }
    }

    public void applyClientBehaviorRendererAnnotations(FacesContext ctx, ClientBehaviorRenderer b) {
        this.applyAnnotations(ctx, b.getClass(), ProcessingTarget.ClientBehaviorRenderer, b);
    }

    public void applyComponentAnnotations(FacesContext ctx, UIComponent c) {
        this.applyAnnotations(ctx, c.getClass(), ProcessingTarget.UIComponent, c);
    }

    public void applyValidatorAnnotations(FacesContext ctx, Validator v) {
        this.applyAnnotations(ctx, v.getClass(), ProcessingTarget.Validator, v);
    }

    public void applyConverterAnnotations(FacesContext ctx, Converter c) {
        this.applyAnnotations(ctx, c.getClass(), ProcessingTarget.Converter, c);
    }

    public void applyRendererAnnotations(FacesContext ctx, Renderer r, UIComponent c) {
        this.applyAnnotations(ctx, r.getClass(), ProcessingTarget.Renderer, r, c);
    }

    public void applySystemEventAnnotations(FacesContext ctx, SystemEvent e) {
        this.applyAnnotations(ctx, e.getClass(), ProcessingTarget.SystemEvent, e);
    }

    private Map<Class<? extends Annotation>, ConfigAnnotationHandler> getConfigAnnotationHandlers() {
        ConfigAnnotationHandler[] handlers = new ConfigAnnotationHandler[]{new ComponentConfigHandler(), new ConverterConfigHandler(), new ValidatorConfigHandler(), new BehaviorConfigHandler(), new RenderKitConfigHandler(), new ManagedBeanConfigHandler(), new NamedEventConfigHandler()};
        HashMap<Class<? extends Annotation>, ConfigAnnotationHandler> handlerMap = new HashMap<Class<? extends Annotation>, ConfigAnnotationHandler>();
        for (ConfigAnnotationHandler handler : handlers) {
            Collection<Class<? extends Annotation>> handledClasses = handler.getHandledAnnotations();
            for (Class<? extends Annotation> handled : handledClasses) {
                handlerMap.put(handled, handler);
            }
        }
        return handlerMap;
    }

    private void applyAnnotations(FacesContext ctx, Class<?> targetClass, ProcessingTarget processingTarget, Object ... params) {
        Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = this.getHandlerMap(targetClass, processingTarget);
        if (map != null && !map.isEmpty()) {
            for (RuntimeAnnotationHandler handler : map.values()) {
                handler.apply(ctx, params);
            }
        }
    }

    /*
     * Loose catch block
     */
    private Map<Class<? extends Annotation>, RuntimeAnnotationHandler> getHandlerMap(Class<?> targetClass, ProcessingTarget processingTarget) {
        while (true) {
            ProcessAnnotationsTask t;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> ft;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> f;
            if ((f = (FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>)this.cache.get(targetClass)) == null && (f = (Future)this.cache.putIfAbsent(targetClass, ft = new FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>(t = new ProcessAnnotationsTask(targetClass, processingTarget.scanners)))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return (Map)f.get();
            }
            catch (CancellationException ce) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ce.toString(), ce);
                }
                this.cache.remove(targetClass);
                continue;
            }
            catch (InterruptedException ie) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ie.toString(), ie);
                }
                this.cache.remove(targetClass);
                continue;
            }
            break;
        }
        catch (ExecutionException ee) {
            throw new FacesException((Throwable)ee);
        }
    }

    static /* synthetic */ Scanner[] access$000() {
        return BEHAVIOR_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$100() {
        return CLIENT_BEHAVIOR_RENDERER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$200() {
        return UICOMPONENT_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$300() {
        return VALIDATOR_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$400() {
        return CONVERTER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$500() {
        return RENDERER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$600() {
        return EVENTS_SCANNERS;
    }

    private static final class ProcessAnnotationsTask
    implements Callable<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> {
        private static final Map<Class<? extends Annotation>, RuntimeAnnotationHandler> EMPTY = Collections.EMPTY_MAP;
        private Class<?> clazz;
        private Scanner[] scanners;

        public ProcessAnnotationsTask(Class<?> clazz, Scanner[] scanners) {
            this.clazz = clazz;
            this.scanners = scanners;
        }

        @Override
        public Map<Class<? extends Annotation>, RuntimeAnnotationHandler> call() throws Exception {
            Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = null;
            for (Scanner scanner : this.scanners) {
                RuntimeAnnotationHandler handler = scanner.scan(this.clazz);
                if (handler == null) continue;
                if (map == null) {
                    map = new HashMap<Class<? extends Annotation>, RuntimeAnnotationHandler>(2, 1.0f);
                }
                map.put(scanner.getAnnotation(), handler);
            }
            return map != null ? map : EMPTY;
        }
    }

    private static enum ProcessingTarget {
        Behavior(AnnotationManager.access$000()),
        ClientBehaviorRenderer(AnnotationManager.access$100()),
        UIComponent(AnnotationManager.access$200()),
        Validator(AnnotationManager.access$300()),
        Converter(AnnotationManager.access$400()),
        Renderer(AnnotationManager.access$500()),
        SystemEvent(AnnotationManager.access$600());

        private Scanner[] scanners;

        private ProcessingTarget(Scanner[] scanners) {
            this.scanners = scanners;
        }
    }
}

