/*
 * Decompiled with CFR 0.152.
 */
package com.staros.journal;

import com.staros.exception.StarException;
import com.staros.journal.Journal;
import com.staros.journal.JournalSystem;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class DummyJournalSystem
implements JournalSystem {
    private final ConcurrentLinkedQueue<Journal> journalQueue = new ConcurrentLinkedQueue();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void write(Journal journal) throws StarException {
        this.journalQueue.offer(journal);
        this.processWriteInOrder();
    }

    private synchronized void processWriteInOrder() throws StarException {
        Journal journal;
        if (this.journalQueue.isEmpty()) {
            return;
        }
        while (!this.journalQueue.isEmpty() && (journal = this.journalQueue.poll()) != null) {
            this.writeInternal(journal);
        }
    }

    protected void writeInternal(Journal journal) throws StarException {
    }

    @Override
    public Future<Boolean> writeAsync(Journal journal) throws StarException {
        this.journalQueue.offer(journal);
        FutureTask<Boolean> task = new FutureTask<Boolean>(this::processWriteInOrder, true);
        this.executorService.submit(task);
        return task;
    }

    @Override
    public void replayTo(long journalId) throws StarException {
    }

    @Override
    public void setReplayId(long replayId) {
    }

    @Override
    public long getReplayId() {
        return 0L;
    }

    @Override
    public void onBecomeLeader() {
    }

    @Override
    public void onBecomeFollower() {
    }
}

