/*
 * Decompiled with CFR 0.152.
 */
package com.staros.client;

import com.staros.client.StarClient;
import com.staros.client.StarClientException;
import com.staros.proto.StatusCode;

public class StarClientHelper {
    private StarClient client = new StarClient();

    public static void printUsageAndExit() {
        System.out.println("usage: StarClientHelper dump star_manager_ip_port");
        System.out.println("usage: StarClientHelper add star_manager_ip_port worker_ip_port");
        System.exit(-1);
    }

    public void dump() {
        try {
            String location = this.client.dump();
            System.out.println("meta location: " + location + ".");
        }
        catch (StarClientException e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    public void add(String workerIpPort) {
        String serviceName;
        block9: {
            String serviceTemplateName;
            block8: {
                serviceTemplateName = "StarOSTest";
                serviceName = "StarOSTest-1";
                try {
                    this.client.registerService(serviceTemplateName);
                }
                catch (StarClientException e) {
                    if (e.getCode() == StatusCode.ALREADY_EXIST) break block8;
                    System.out.println(e);
                    System.exit(-1);
                }
            }
            try {
                this.client.bootstrapService(serviceTemplateName, serviceName);
            }
            catch (StarClientException e) {
                if (e.getCode() == StatusCode.ALREADY_EXIST) break block9;
                System.out.println(e);
                System.exit(-1);
            }
        }
        String serviceId = null;
        try {
            serviceId = this.client.getServiceInfoByName(serviceName).getServiceId();
        }
        catch (StarClientException e) {
            System.out.println("fail to get service id.");
            System.out.println(e);
            System.exit(-1);
        }
        System.out.println("add worker " + workerIpPort + " to star manager ...");
        try {
            this.client.addWorker(serviceId, workerIpPort);
        }
        catch (StarClientException e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        StarClientHelper helper = new StarClientHelper();
        if (args.length < 2) {
            StarClientHelper.printUsageAndExit();
        }
        System.out.println("connect star manager at " + args[1] + "...");
        helper.client.connectServer(args[1]);
        if (args[0].equals("dump")) {
            helper.dump();
        } else if (args[0].equals("add")) {
            if (args.length != 3) {
                StarClientHelper.printUsageAndExit();
            }
            helper.add(args[2]);
        } else {
            StarClientHelper.printUsageAndExit();
        }
    }
}

