/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso.pollexor;

import android.net.Uri;
import android.os.Build;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.pollexor.Thumbor;
import com.squareup.pollexor.ThumborUrlBuilder;

public class PollexorRequestTransformer
implements Picasso.RequestTransformer {
    private final Thumbor thumbor;

    public PollexorRequestTransformer(Thumbor thumbor) {
        this.thumbor = thumbor;
    }

    public Request transformRequest(Request request) {
        if (request.resourceId != 0) {
            return request;
        }
        Uri uri = request.uri;
        String scheme = uri.getScheme();
        if (!"https".equals(scheme) && !"http".equals(scheme)) {
            return request;
        }
        if (!request.hasSize()) {
            return request;
        }
        Request.Builder newRequest = request.buildUpon();
        ThumborUrlBuilder urlBuilder = this.thumbor.buildImage(uri.toString());
        urlBuilder.resize(request.targetWidth, request.targetHeight);
        newRequest.clearResize();
        if (request.centerInside) {
            urlBuilder.fitIn();
            newRequest.clearCenterInside();
        }
        if (Build.VERSION.SDK_INT >= 18) {
            urlBuilder.filter(new String[]{ThumborUrlBuilder.format((ThumborUrlBuilder.ImageFormat)ThumborUrlBuilder.ImageFormat.WEBP)});
        }
        newRequest.setUri(Uri.parse((String)urlBuilder.toUrl()));
        return newRequest.build();
    }
}

