//[okio](../../../index.md)/[okio](../index.md)/[ForwardingFileSystem](index.md)/[listRecursively](list-recursively.md)

# listRecursively

[common]\
open override fun [listRecursively](list-recursively.md)(dir: [Path](../-path/index.md), followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;[Path](../-path/index.md)&gt;

Returns a sequence that **lazily** traverses the children of [dir](list-recursively.md) using repeated calls to [list](list.md). If none of [dir](list-recursively.md)'s children are directories this returns the same elements as [list](list.md).

The returned sequence visits the tree of files in depth-first order. Parent paths are returned before their children.

Note that [listRecursively](list-recursively.md) does not throw exceptions but the returned sequence does. When it is iterated, the returned sequence throws a [FileNotFoundException](../-file-not-found-exception/index.md) if [dir](list-recursively.md) does not exist, or an [IOException](../-i-o-exception/index.md) if [dir](list-recursively.md) cannot be listed.

## Parameters

common

| | |
|---|---|
| followSymlinks | true to follow symlinks while traversing the children. If [dir](list-recursively.md) itself is     a symlink it will be followed even if this parameter is false. |
