/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javawriter;

import java.util.Formatter;

public final class StringLiteral {
    private final String value;
    private final String literal;

    public static StringLiteral forValue(String value) {
        return new StringLiteral(value, StringLiteral.stringLiteral(value));
    }

    private static String stringLiteral(String value) {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        new Formatter(result).format("\\u%04x", c);
                        continue block9;
                    }
                    result.append(c);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    private StringLiteral(String value, String literal) {
        this.value = value;
        this.literal = literal;
    }

    public String value() {
        return this.value;
    }

    public String literal() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringLiteral) {
            return this.value.equals(((StringLiteral)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

