/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.glassfish.jersey.message.internal;

import com.spotify.docker.client.shaded.javax.inject.Singleton;
import com.spotify.docker.client.shaded.javax.ws.rs.Consumes;
import com.spotify.docker.client.shaded.javax.ws.rs.Produces;
import com.spotify.docker.client.shaded.javax.ws.rs.WebApplicationException;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MediaType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MultivaluedMap;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.internal.ReaderWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Singleton
@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
final class EnumMessageProvider
extends AbstractMessageReaderWriterProvider<Enum> {
    EnumMessageProvider() {
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isEnum();
    }

    @Override
    public Enum readFrom(Class<Enum> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String value = ReaderWriter.readFromAsString(entityStream, mediaType);
        return Enum.valueOf(type, value);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isEnum();
    }

    @Override
    public void writeTo(Enum anEnum, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ReaderWriter.writeToAsString(anEnum.name(), entityStream, mediaType);
    }
}

