/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.glassfish.jersey.jackson;

import com.spotify.docker.client.shaded.javax.ws.rs.core.Configuration;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Feature;
import com.spotify.docker.client.shaded.javax.ws.rs.core.FeatureContext;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.MessageBodyReader;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.MessageBodyWriter;
import com.spotify.docker.client.shaded.org.glassfish.jersey.CommonProperties;
import com.spotify.docker.client.shaded.org.glassfish.jersey.internal.util.PropertiesHelper;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.DefaultJacksonJaxbJsonProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.JaxrsFeatureBag;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.JaxRSFeature;
import com.spotify.docker.client.shaded.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.MessageProperties;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
extends JaxrsFeatureBag<JacksonFeature>
implements Feature {
    private final boolean registerExceptionMappers;
    private int maxStringLength = 20000000;
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    public JacksonFeature() {
        this(true);
    }

    private JacksonFeature(boolean registerExceptionMappers) {
        this.registerExceptionMappers = registerExceptionMappers;
    }

    public static JacksonFeature withExceptionMappers() {
        return new JacksonFeature();
    }

    public static JacksonFeature withoutExceptionMappers() {
        return new JacksonFeature(false);
    }

    public JacksonFeature maxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        return this;
    }

    @Override
    public JacksonFeature jaxrsFeature(JaxRSFeature feature, boolean state) {
        return (JacksonFeature)super.jaxrsFeature(feature, state);
    }

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            if (this.registerExceptionMappers) {
                context.register(JsonParseExceptionMapper.class);
                context.register(JsonMappingExceptionMapper.class);
            }
            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(DefaultJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }
        if (config.getProperty(MessageProperties.JSON_MAX_STRING_LENGTH) == null) {
            context.property(MessageProperties.JSON_MAX_STRING_LENGTH, this.maxStringLength);
        }
        if (this.hasJaxrsFeature()) {
            context.property("jersey.config.jackson.jaxrs.feature", this);
        }
        return true;
    }
}

