/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.unixsocket;

import com.spotify.docker.client.shaded.jnr.constants.platform.ProtocolFamily;
import com.spotify.docker.client.shaded.jnr.constants.platform.SocketLevel;
import com.spotify.docker.client.shaded.jnr.constants.platform.SocketOption;
import com.spotify.docker.client.shaded.jnr.ffi.Platform;
import com.spotify.docker.client.shaded.jnr.ffi.byref.IntByReference;
import com.spotify.docker.client.shaded.jnr.unixsocket.Credentials;
import com.spotify.docker.client.shaded.jnr.unixsocket.Native;
import com.spotify.docker.client.shaded.jnr.unixsocket.SockAddrUnix;
import com.spotify.docker.client.shaded.jnr.unixsocket.UnixSocketAddress;
import com.spotify.docker.client.shaded.jnr.unixsocket.UnixSocketOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

final class Common {
    private static Platform.OS currentOS = Platform.getNativePlatform().getOS();
    private static final Map<java.net.SocketOption<?>, SocketOption> wMap = new HashMap();
    private static final Map<java.net.SocketOption<?>, SocketOption> rMap = new HashMap();

    private Common() {
    }

    static UnixSocketAddress bind(int fd, UnixSocketAddress local) throws IOException {
        SockAddrUnix sa;
        if (null == local) {
            sa = SockAddrUnix.create();
            sa.setFamily(ProtocolFamily.PF_UNIX);
            if (currentOS == Platform.OS.LINUX) {
                sa.setPath("");
            } else {
                File f = Files.createTempFile("com.spotify.docker.client.shaded.jnr-unixsocket-tmp", ".sock", new FileAttribute[0]).toFile();
                f.deleteOnExit();
                f.delete();
                sa.setPath(f.getPath());
            }
        } else {
            sa = local.getStruct();
        }
        if (Native.bind(fd, sa, sa.length()) < 0) {
            throw new IOException(Native.getLastErrorString());
        }
        return Common.getsockname(fd);
    }

    static UnixSocketAddress getsockname(int sockfd) {
        UnixSocketAddress local = new UnixSocketAddress();
        SockAddrUnix addr = local.getStruct();
        IntByReference len = new IntByReference(addr.getMaximumLength());
        if (Native.libc().getsockname(sockfd, addr, len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        addr.updatePath((Integer)len.getValue());
        return local;
    }

    static UnixSocketAddress getpeername(int sockfd) {
        UnixSocketAddress remote = new UnixSocketAddress();
        SockAddrUnix addr = remote.getStruct();
        IntByReference len = new IntByReference(addr.getMaximumLength());
        if (Native.libc().getpeername(sockfd, addr, len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        addr.updatePath((Integer)len.getValue());
        return remote;
    }

    static <T> T getSocketOption(int fd, java.net.SocketOption<?> name) throws IOException {
        SocketOption optname = rMap.get(name);
        if (null == optname) {
            throw new AssertionError((Object)"Option not found");
        }
        Class<?> type = name.type();
        if (type == Credentials.class) {
            return (T)Credentials.getCredentials(fd);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(Native.getsockopt(fd, SocketLevel.SOL_SOCKET, optname.intValue()));
        }
        return (T)Boolean.valueOf(Native.getboolsockopt(fd, SocketLevel.SOL_SOCKET, optname.intValue()));
    }

    static void setSocketOption(int fd, java.net.SocketOption<?> name, Object value) throws IOException {
        int i;
        int optvalue;
        if (null == value) {
            throw new IllegalArgumentException("Invalid option value");
        }
        SocketOption optname = wMap.get(name);
        if (null == optname) {
            throw new AssertionError((Object)"Option not found or not writable");
        }
        Class<?> type = name.type();
        if (type != Integer.class && type != Boolean.class) {
            throw new AssertionError((Object)"Unsupported option type");
        }
        if (type == Integer.class) {
            optvalue = (Integer)value;
        } else {
            int n = optvalue = (Boolean)value != false ? 1 : 0;
        }
        if ((name == UnixSocketOptions.SO_RCVBUF || name == UnixSocketOptions.SO_SNDBUF) && (i = ((Integer)value).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive buffer size");
        }
        if ((name == UnixSocketOptions.SO_RCVTIMEO || name == UnixSocketOptions.SO_SNDTIMEO) && (i = ((Integer)value).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive timeout");
        }
        if (0 != Native.setsockopt(fd, SocketLevel.SOL_SOCKET, optname, optvalue)) {
            throw new IOException(Native.getLastErrorString());
        }
    }

    static {
        wMap.put(UnixSocketOptions.SO_RCVBUF, SocketOption.SO_RCVBUF);
        wMap.put(UnixSocketOptions.SO_SNDBUF, SocketOption.SO_SNDBUF);
        wMap.put(UnixSocketOptions.SO_RCVTIMEO, SocketOption.SO_RCVTIMEO);
        wMap.put(UnixSocketOptions.SO_SNDTIMEO, SocketOption.SO_SNDTIMEO);
        wMap.put(UnixSocketOptions.SO_KEEPALIVE, SocketOption.SO_KEEPALIVE);
        wMap.put(UnixSocketOptions.SO_PASSCRED, SocketOption.SO_PASSCRED);
        rMap.putAll(wMap);
        rMap.put(UnixSocketOptions.SO_PEERCRED, SocketOption.SO_PEERCRED);
    }
}

