/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.posix;

import com.spotify.docker.client.shaded.jnr.constants.platform.Confstr;
import com.spotify.docker.client.shaded.jnr.constants.platform.Pathconf;
import com.spotify.docker.client.shaded.jnr.constants.platform.Sysconf;
import com.spotify.docker.client.shaded.jnr.ffi.LibraryLoader;
import com.spotify.docker.client.shaded.jnr.ffi.Memory;
import com.spotify.docker.client.shaded.jnr.ffi.Platform;
import com.spotify.docker.client.shaded.jnr.ffi.Pointer;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.posix.BaseNativePOSIX;
import com.spotify.docker.client.shaded.jnr.posix.FileStat;
import com.spotify.docker.client.shaded.jnr.posix.LibCProvider;
import com.spotify.docker.client.shaded.jnr.posix.MacOSFileStat;
import com.spotify.docker.client.shaded.jnr.posix.MacOSFileStat64Inode;
import com.spotify.docker.client.shaded.jnr.posix.MacOSMsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.MacOSPasswd;
import com.spotify.docker.client.shaded.jnr.posix.MacOSSocketMacros;
import com.spotify.docker.client.shaded.jnr.posix.MsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.NSGetEnviron;
import com.spotify.docker.client.shaded.jnr.posix.NativeTimes;
import com.spotify.docker.client.shaded.jnr.posix.POSIXHandler;
import com.spotify.docker.client.shaded.jnr.posix.SocketMacros;
import com.spotify.docker.client.shaded.jnr.posix.Times;
import java.nio.ByteBuffer;

final class MacOSPOSIX
extends BaseNativePOSIX {
    private final NSGetEnviron environ;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        this.environ = loader.load();
    }

    @Override
    public FileStat allocateStat() {
        if (Platform.getNativePlatform().getCPU() == Platform.CPU.AARCH64) {
            return new MacOSFileStat64Inode(this);
        }
        return new MacOSFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public int confstr(Confstr name, ByteBuffer buf, int len) {
        return this.libc().confstr(name, buf, len);
    }

    @Override
    public int fpathconf(int fd, Pathconf name) {
        return this.libc().fpathconf(fd, name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return this.environ._NSGetEnviron().getPointer(0L);
    }
}

