/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.posix;

import com.spotify.docker.client.shaded.jnr.constants.platform.Confstr;
import com.spotify.docker.client.shaded.jnr.constants.platform.Pathconf;
import com.spotify.docker.client.shaded.jnr.constants.platform.Sysconf;
import com.spotify.docker.client.shaded.jnr.ffi.Memory;
import com.spotify.docker.client.shaded.jnr.ffi.Pointer;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.posix.BaseNativePOSIX;
import com.spotify.docker.client.shaded.jnr.posix.FileStat;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDFileStat;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDFileStat12;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDMsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDPasswd;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDSocketMacros;
import com.spotify.docker.client.shaded.jnr.posix.LibCProvider;
import com.spotify.docker.client.shaded.jnr.posix.MsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.NativeTimes;
import com.spotify.docker.client.shaded.jnr.posix.POSIXHandler;
import com.spotify.docker.client.shaded.jnr.posix.SocketMacros;
import com.spotify.docker.client.shaded.jnr.posix.Times;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParsePosition;

final class FreeBSDPOSIX
extends BaseNativePOSIX {
    private final int freebsdVersion;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new FreeBSDPasswd((Pointer)arg) : null;
        }
    };

    FreeBSDPOSIX(LibCProvider libc, POSIXHandler handler) {
        super(libc, handler);
        int parsed_version = 0;
        try {
            Process p = Runtime.getRuntime().exec("/bin/freebsd-version -u");
            String version = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
            if (p.waitFor() == 0 && version != null) {
                NumberFormat fmt = NumberFormat.getIntegerInstance();
                fmt.setGroupingUsed(false);
                parsed_version = fmt.parse(version, new ParsePosition(0)).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.freebsdVersion = parsed_version;
    }

    @Override
    public FileStat allocateStat() {
        if (this.freebsdVersion >= 12) {
            return new FreeBSDFileStat12(this);
        }
        return new FreeBSDFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new FreeBSDMsgHdr(this);
    }

    @Override
    public SocketMacros socketMacros() {
        return FreeBSDSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public int confstr(Confstr name, ByteBuffer buf, int len) {
        return this.libc().confstr(name, buf, len);
    }

    @Override
    public int fpathconf(int fd, Pathconf name) {
        return this.libc().fpathconf(fd, name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }
}

