/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.posix;

import com.spotify.docker.client.shaded.jnr.constants.platform.Confstr;
import com.spotify.docker.client.shaded.jnr.constants.platform.Fcntl;
import com.spotify.docker.client.shaded.jnr.constants.platform.Pathconf;
import com.spotify.docker.client.shaded.jnr.constants.platform.Sysconf;
import com.spotify.docker.client.shaded.jnr.ffi.Memory;
import com.spotify.docker.client.shaded.jnr.ffi.Pointer;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.posix.AixFileStat;
import com.spotify.docker.client.shaded.jnr.posix.AixFlock;
import com.spotify.docker.client.shaded.jnr.posix.AixPasswd;
import com.spotify.docker.client.shaded.jnr.posix.AixTimeval;
import com.spotify.docker.client.shaded.jnr.posix.BaseNativePOSIX;
import com.spotify.docker.client.shaded.jnr.posix.FileStat;
import com.spotify.docker.client.shaded.jnr.posix.Flock;
import com.spotify.docker.client.shaded.jnr.posix.LibCProvider;
import com.spotify.docker.client.shaded.jnr.posix.MsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.NativeTimes;
import com.spotify.docker.client.shaded.jnr.posix.POSIXHandler;
import com.spotify.docker.client.shaded.jnr.posix.SocketMacros;
import com.spotify.docker.client.shaded.jnr.posix.Times;
import com.spotify.docker.client.shaded.jnr.posix.Timeval;
import com.spotify.docker.client.shaded.jnr.posix.util.MethodName;
import java.nio.ByteBuffer;

final class AixPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new AixPasswd((Pointer)arg) : null;
        }
    };

    AixPOSIX(LibCProvider libc, POSIXHandler handler) {
        super(libc, handler);
    }

    @Override
    public FileStat allocateStat() {
        return new AixFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public SocketMacros socketMacros() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public int confstr(Confstr name, ByteBuffer buf, int len) {
        return this.libc().confstr(name, buf, len);
    }

    @Override
    public int fpathconf(int fd, Pathconf name) {
        return this.libc().fpathconf(fd, name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 4);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 60);
    }

    @Override
    public int flock(int fd, int operation) {
        int cmd = Fcntl.F_SETLKW.intValue();
        short type = 0;
        if ((operation & FlockFlags.LOCK_SH.intValue()) != 0) {
            type = (short)Fcntl.F_RDLCK.intValue();
        } else if ((operation & FlockFlags.LOCK_EX.intValue()) != 0) {
            type = (short)Fcntl.F_WRLCK.intValue();
        } else if ((operation & FlockFlags.LOCK_UN.intValue()) != 0) {
            type = (short)Fcntl.F_UNLCK.intValue();
        }
        if ((operation & FlockFlags.LOCK_NB.intValue()) != 0) {
            cmd = Fcntl.F_SETLK.intValue();
        }
        Flock flock = this.allocateFlock();
        flock.type(type);
        flock.whence((short)0);
        flock.start(0L);
        flock.len(0L);
        return this.libc().fcntl(fd, cmd, flock);
    }

    @Override
    public Timeval allocateTimeval() {
        return new AixTimeval(this.getRuntime());
    }

    public Flock allocateFlock() {
        return new AixFlock(this.getRuntime());
    }

    private static enum FlockFlags {
        LOCK_SH(1),
        LOCK_EX(2),
        LOCK_NB(4),
        LOCK_UN(8);

        private final int value;

        private FlockFlags(int value) {
            this.value = value;
        }

        public final int intValue() {
            return this.value;
        }
    }
}

