/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.ffi.provider.jffi;

import com.spotify.docker.client.shaded.jnr.ffi.Pointer;
import com.spotify.docker.client.shaded.jnr.ffi.Runtime;
import com.spotify.docker.client.shaded.jnr.ffi.Struct;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.provider.converters.StructByReferenceFromNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.provider.jffi.AsmClassLoader;
import com.spotify.docker.client.shaded.jnr.ffi.provider.jffi.AsmStructByReferenceFromNativeConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class StructByReferenceResultConverterFactory {
    private final Map<Class<? extends Struct>, FromNativeConverter<? extends Struct, Pointer>> converters = new ConcurrentHashMap<Class<? extends Struct>, FromNativeConverter<? extends Struct, Pointer>>();
    private final AsmClassLoader classLoader;
    private final boolean asmEnabled;

    public StructByReferenceResultConverterFactory(AsmClassLoader classLoader, boolean asmEnabled) {
        this.classLoader = classLoader;
        this.asmEnabled = asmEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FromNativeConverter<? extends Struct, Pointer> get(Class<? extends Struct> structClass, FromNativeContext fromNativeContext) {
        FromNativeConverter<? extends Struct, Pointer> converter = this.converters.get(structClass);
        if (converter == null) {
            Map<Class<? extends Struct>, FromNativeConverter<? extends Struct, Pointer>> map = this.converters;
            synchronized (map) {
                converter = this.converters.get(structClass);
                if (converter == null) {
                    converter = this.createConverter(fromNativeContext.getRuntime(), structClass, fromNativeContext);
                    this.converters.put(structClass, converter);
                }
            }
        }
        return converter;
    }

    private FromNativeConverter<? extends Struct, Pointer> createConverter(Runtime runtime, Class<? extends Struct> structClass, FromNativeContext fromNativeContext) {
        return this.asmEnabled ? AsmStructByReferenceFromNativeConverter.newStructByReferenceConverter(runtime, structClass, 0, this.classLoader) : StructByReferenceFromNativeConverter.getInstance(structClass, fromNativeContext);
    }
}

