/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.constants.platform.windows;

import com.spotify.docker.client.shaded.jnr.constants.Constant;
import java.util.EnumMap;
import java.util.Map;

public enum ErrnoAddressInfo implements Constant
{
    EAI_AGAIN(11002L),
    EAI_BADFLAGS(10022L),
    EAI_FAIL(11003L),
    EAI_FAMILY(10047L),
    EAI_MEMORY(8L),
    EAI_NODATA(11004L),
    EAI_NONAME(11001L),
    EAI_SERVICE(10109L),
    EAI_SOCKTYPE(10044L);

    private final long value;
    public static final long MIN_VALUE = 8L;
    public static final long MAX_VALUE = 11004L;

    private ErrnoAddressInfo(long value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<ErrnoAddressInfo, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<ErrnoAddressInfo, String> generateTable() {
            EnumMap<ErrnoAddressInfo, String> map = new EnumMap<ErrnoAddressInfo, String>(ErrnoAddressInfo.class);
            map.put(EAI_AGAIN, "EAI_AGAIN");
            map.put(EAI_BADFLAGS, "EAI_BADFLAGS");
            map.put(EAI_FAIL, "EAI_FAIL");
            map.put(EAI_FAMILY, "EAI_FAMILY");
            map.put(EAI_MEMORY, "EAI_MEMORY");
            map.put(EAI_NODATA, "EAI_NODATA");
            map.put(EAI_NONAME, "EAI_NONAME");
            map.put(EAI_SERVICE, "EAI_SERVICE");
            map.put(EAI_SOCKTYPE, "EAI_SOCKTYPE");
            return map;
        }
    }
}

